/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.access.ExtendedPropertyAccessor;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TrackedParametersSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.UpstreamSource;
import com.pingidentity.admin.api.validator.structures.UpstreamSources;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class AbstractAuthnPolicyAttributeMappingValidator
extends BaseAttributeDataSourceValidator {
    private final String rootFieldPath;

    public AbstractAuthnPolicyAttributeMappingValidator(String rootFieldPath, ValidatorContext context) {
        super(context);
        this.rootFieldPath = rootFieldPath;
    }

    protected void populateValidators(AttributeMapping attributeMapping, C2cContract apc, UpstreamSources successfulAuthnSources, List<String> trackedParams) {
        if (attributeMapping == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.getAttributeMappingFieldRequiredMessageKey(), this.getAttributeMappingFieldPath()));
            return;
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        HashSet<String> substitutionVars = new HashSet<String>();
        if (trackedParams != null && !trackedParams.isEmpty()) {
            TrackedParametersSourceTypeValidatorBuilder trackedParamsValidator = new TrackedParametersSourceTypeValidatorBuilder(trackedParams);
            rootSources.put(new SourceTypeIdKey(SourceType.TRACKED_HTTP_PARAMS, "trackedparams"), trackedParamsValidator);
            substitutionVars.addAll(trackedParamsValidator.getExposedSubstitutionVariables());
        }
        this.addContextSources(rootSources);
        this.addExtendedPropertiesSources(rootSources, substitutionVars);
        this.addExtraRootSources(rootSources, substitutionVars);
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>(rootSources);
        for (UpstreamSource successfulAuthnSource : successfulAuthnSources.getSources()) {
            PolicyFragment fragment;
            Set allAttributeNames;
            String attrSrcKey;
            if (successfulAuthnSource.getType() == UpstreamSource.UpstreamSourceType.IDP_ADAPTER) {
                IdpAuthnAdapterInstance sourceAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(successfulAuthnSource.getId());
                if (sourceAdapter == null) continue;
                attrSrcKey = org.sourceid.saml20.domain.AttributeMapping.createAttrSourceKey((org.sourceid.saml20.domain.SourceType)org.sourceid.saml20.domain.SourceType.ADAPTER, (String)sourceAdapter.getId());
                allAttributeNames = sourceAdapter.getAttributeContract().getAllAttributeNames();
                AttributeSetSourceTypeValidatorBuilder adapterAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(allAttributeNames, SourceType.ADAPTER, attrSrcKey);
                substitutionVars.addAll(adapterAttributeBuilder.getExposedSubstitutionVariables());
                validSources.put(new SourceTypeIdKey(SourceType.ADAPTER, sourceAdapter.getId()), adapterAttributeBuilder);
                continue;
            }
            if (successfulAuthnSource.getType() == UpstreamSource.UpstreamSourceType.IDP_CONNECTION) {
                IdpConnection conn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(successfulAuthnSource.getId(), false);
                if (conn == null) continue;
                attrSrcKey = org.sourceid.saml20.domain.AttributeMapping.createAttrSourceKey((org.sourceid.saml20.domain.SourceType)org.sourceid.saml20.domain.SourceType.IDP_CONNECTION, (String)conn.getEntityId());
                allAttributeNames = conn.getAttributeContract().getAllAttributeNames();
                AttributeSetSourceTypeValidatorBuilder idpConnAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(allAttributeNames, SourceType.IDP_CONNECTION, attrSrcKey);
                substitutionVars.addAll(idpConnAttributeBuilder.getExposedSubstitutionVariables());
                validSources.put(new SourceTypeIdKey(SourceType.IDP_CONNECTION, conn.getId()), idpConnAttributeBuilder);
                continue;
            }
            if (successfulAuthnSource.getType() != UpstreamSource.UpstreamSourceType.FRAGMENT || (fragment = MgmtFactory.getPolicyFragmentManager().getFragment(successfulAuthnSource.getId())) == null) continue;
            attrSrcKey = org.sourceid.saml20.domain.AttributeMapping.createAttrSourceKey((org.sourceid.saml20.domain.SourceType)org.sourceid.saml20.domain.SourceType.FRAGMENT, (String)fragment.getId());
            allAttributeNames = fragment.getOutputContractAllAttributes();
            AttributeSetSourceTypeValidatorBuilder fragmentAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(allAttributeNames, SourceType.FRAGMENT, attrSrcKey);
            substitutionVars.addAll(fragmentAttributeBuilder.getExposedSubstitutionVariables());
            validSources.put(new SourceTypeIdKey(SourceType.FRAGMENT, fragment.getId()), fragmentAttributeBuilder);
        }
        for (int i = 0; i < attributeMapping.getAttributeSources().size(); ++i) {
            this.addValidator((Validator)new NotBlankValidator(attributeMapping.getAttributeSources().get(i).getId(), "Attribute Source ID", this.getAttributeSourceIdFieldPath(i)));
        }
        this.mapDataStoreTypesToDsValidators(attributeMapping, validSources);
        this.addValidator((Validator)new AttributeMappingValidator(attributeMapping, this.getAllAttributeNames(apc), substitutionVars, "apc mapping", validSources, this.getAttributeMappingFieldPath(), this.getContext()));
    }

    protected void addContextSources(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources) {
        rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT, "context"), this.createAuthnPolicyContextTypeBuilder());
    }

    protected void addExtendedPropertiesSources(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources, Set<String> substitutionVars) {
        Map extendedPropertyMap = new ExtendedPropertyAccessor().getExtendedPropertyDefinitions();
        if (!extendedPropertyMap.isEmpty()) {
            ExtendedMetadataSourceTypeValidatorBuilder extendedPropertiesValidatorBuilder = new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES);
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES, "extproperties"), extendedPropertiesValidatorBuilder);
            substitutionVars.addAll(extendedPropertiesValidatorBuilder.getExposedSubstitutionVariables());
        }
    }

    protected void addExtraRootSources(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources, Set<String> substitutionVars) {
    }

    protected abstract ApiMessageKey getAttributeMappingFieldRequiredMessageKey();

    protected abstract String getAttributeSourceIdFieldPath(int var1);

    protected abstract String getAttributeMappingFieldPath();

    private Set<String> getAllAttributeNames(C2cContract apc) {
        return apc != null ? apc.getAllAttributeNames() : Collections.emptySet();
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    protected String makeFieldPath(String suffix) {
        if (this.rootFieldPath == null) {
            return suffix;
        }
        return this.rootFieldPath + "." + suffix;
    }
}

