/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeRule;
import com.pingidentity.admin.api.model.AttributeRules;
import com.pingidentity.admin.api.model.AuthenticationPolicySelectionActionType;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.model.AuthenticationSourceType;
import com.pingidentity.admin.api.model.AuthnSourcePolicyAction;
import com.pingidentity.admin.api.model.FragmentPolicyAction;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyTreeNodePaths;
import com.pingidentity.admin.api.validator.AbstractActionValidator;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.admin.api.validator.structures.UpstreamSource;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class AbstractAuthnSourceActionValidator
extends AbstractActionValidator {
    private final ValidatorContext context;

    public AbstractAuthnSourceActionValidator(ActionValidatorInfo info, ValidatorContext context) {
        super(info);
        this.context = context;
    }

    protected void validateAttributeRules(AttributeRules attributeRules) {
        if (attributeRules != null) {
            List<AttributeRule> attributeRuleList = attributeRules.getItems();
            if (attributeRuleList == null || attributeRuleList.isEmpty()) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rules_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRules())));
            } else {
                this.validateUniqueAttributeRulesResults(attributeRuleList);
                Map<SourceType, Map<String, List<String>>> authnSourceToAttributeContractNames = this.getAuthnSourceToAttributeContractNames();
                Set<String> substitutionValues = this.getSubstitutionValues(authnSourceToAttributeContractNames);
                List<String> previousAttributeContractNames = this.getPreviousAuthenticationSource(authnSourceToAttributeContractNames);
                int attrRuleItem = 0;
                for (AttributeRule attributeRule : attributeRuleList) {
                    if (StringUtils.isBlank((String)attributeRule.getAttributeName()) && this.isNotExpressionRule(attributeRule)) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_attribute_name_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemAttributeName(attrRuleItem))));
                    } else if (attributeRule.getAttributeSource() == null) {
                        if (!previousAttributeContractNames.contains(attributeRule.getAttributeName())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_attribute_name_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemAttributeName(attrRuleItem))));
                        }
                    } else if (this.isNotExpressionRule(attributeRule)) {
                        Map<String, List<String>> attributeContractNamesForType = authnSourceToAttributeContractNames.get((Object)attributeRule.getAttributeSource().getType());
                        if (attributeContractNamesForType == null) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_attribute_source_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemAttributeSource(attrRuleItem))));
                        } else {
                            List<String> attributeContractNames = attributeContractNamesForType.get(attributeRule.getAttributeSource().getId());
                            if (attributeContractNames == null) {
                                this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_attribute_source_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemAttributeSource(attrRuleItem))));
                            } else if (!attributeContractNames.contains(attributeRule.getAttributeName())) {
                                this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_attribute_name_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemAttributeName(attrRuleItem))));
                            }
                        }
                    } else if (StringUtils.isNotBlank((String)attributeRule.getAttributeName())) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_attribute_name_not_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemAttributeName(attrRuleItem))));
                    }
                    if (this.isNotExpressionRule(attributeRule)) {
                        if (attributeRule.getCondition() == null) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_condition_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemCondition(attrRuleItem))));
                        }
                        if (StringUtils.isBlank((String)attributeRule.getExpectedValue())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_expected_value_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemExpectedValue(attrRuleItem))));
                        }
                        if (StringUtils.isNotBlank((String)attributeRule.getExpression())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_expression_not_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemExpression(attrRuleItem))));
                        }
                    } else {
                        if (StringUtils.isBlank((String)attributeRule.getExpression())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_expression_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemExpression(attrRuleItem))));
                        } else if (ExpressionManager.getInstance().isEvaluateExpressionsOff()) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_expression_not_enabled, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemExpression(attrRuleItem))));
                        } else if (this.context.isAllowExpressionUpdates()) {
                            ExpressionSourceTypeValidatorBuilder expressionSourceTypeValidatorBuilder = new ExpressionSourceTypeValidatorBuilder(this.context);
                            expressionSourceTypeValidatorBuilder.setSubstitutionVariables(substitutionValues);
                            Validator expressionValidator = expressionSourceTypeValidatorBuilder.buildMappingValidator(attributeRule.getExpression(), this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemExpression(attrRuleItem)));
                            expressionValidator.validate();
                            if (expressionValidator.hasErrors()) {
                                this.appendErrors(expressionValidator.getErrors());
                            }
                        } else {
                            this.appendError(this.errorFactory.create(ApiMessageKey.expression_admin_role_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemExpression(attrRuleItem))));
                        }
                        if (attributeRule.getCondition() != null) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_condition_not_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemCondition(attrRuleItem))));
                        }
                        if (StringUtils.isNotBlank((String)attributeRule.getExpectedValue())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_expected_value_not_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemExpectedValue(attrRuleItem))));
                        }
                    }
                    if (StringUtils.isBlank((String)attributeRule.getResult())) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_result_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemResult(attrRuleItem))));
                    } else if (attributeRule.getResult().equals("Success") || attributeRule.getResult().equals("Fail")) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_attribute_rule_result_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemResult(attrRuleItem))));
                    } else {
                        ArrayList<String> childContexts = new ArrayList<String>();
                        for (AuthenticationPolicyTreeNode child : this.validatorInfo.getChildren()) {
                            if (child == null || child.getAction() == null || child.getAction().getContext() == null) continue;
                            childContexts.add(child.getAction().getContext());
                        }
                        if (!childContexts.contains(attributeRule.getResult())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_child_missing_for_attribute_rule, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRulesItemResult(attrRuleItem)), new Object[]{attributeRule.getResult()}));
                        }
                        if (childContexts.size() == attributeRuleList.size() + 2 && !((String)childContexts.get(attrRuleItem + 1)).equals(attributeRule.getResult())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_invalid_children_order_for_authn_source_action_with_attr_rules, this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getChildren(attrRuleItem + 1))));
                        }
                    }
                    ++attrRuleItem;
                }
            }
        }
    }

    private boolean isNotExpressionRule(AttributeRule attributeRule) {
        return attributeRule.getAttributeSource() == null || !SourceType.EXPRESSION.equals((Object)attributeRule.getAttributeSource().getType());
    }

    private void validateUniqueAttributeRulesResults(List<AttributeRule> attributeRuleList) {
        UniqueEntriesValidator.UniqueKeyGetter<AttributeRule> attributeRuleUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<AttributeRule>(){

            @Override
            public String getKey(AttributeRule object) {
                if (object.getResult() != null) {
                    return object.getResult();
                }
                return null;
            }
        };
        UniqueEntriesValidator<AttributeRule> uniqueEntriesValidator = new UniqueEntriesValidator<AttributeRule>(attributeRuleUniqueKeyGetter, attributeRuleList, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeRules()), ApiMessageKey.authn_source_attribute_rule_result_duplicate, ApiMessageKey.authn_source_attribute_rule_required);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }

    private Map<SourceType, Map<String, List<String>>> getAuthnSourceToAttributeContractNames() {
        LinkedHashMap<SourceType, Map<String, List<String>>> authnSourceToAttributeContracts = new LinkedHashMap<SourceType, Map<String, List<String>>>();
        LinkedHashMap idToAttributeContract = new LinkedHashMap();
        if (AuthenticationPolicySelectionActionType.AUTHN_SOURCE.equals((Object)this.validatorInfo.getAction().getType())) {
            AuthenticationSource authenticationSource = ((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getAuthenticationSource();
            if (authenticationSource.getType() == AuthenticationSourceType.IDP_ADAPTER) {
                IdpAuthnAdapterInstance adapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(authenticationSource.getSourceRef().getId());
                idToAttributeContract.put(authenticationSource.getSourceRef().getId(), new ArrayList(adapter.getAttributeContract().getAllAttributeNames()));
                authnSourceToAttributeContracts.put(SourceType.ADAPTER, idToAttributeContract);
            }
            if (authenticationSource.getType() == AuthenticationSourceType.IDP_CONNECTION) {
                IdpConnection conn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(authenticationSource.getSourceRef().getId(), false);
                idToAttributeContract.put(authenticationSource.getSourceRef().getId(), new ArrayList(conn.getAttributeContract().getAllAttributeNames()));
                authnSourceToAttributeContracts.put(SourceType.IDP_CONNECTION, idToAttributeContract);
            }
        } else if (AuthenticationPolicySelectionActionType.FRAGMENT.equals((Object)this.validatorInfo.getAction().getType())) {
            String fragmentId = ((FragmentPolicyAction)this.validatorInfo.getAction()).getFragment().getId();
            PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(fragmentId);
            idToAttributeContract.put(fragmentId, new ArrayList(fragment.getOutputContractAllAttributes()));
            authnSourceToAttributeContracts.put(SourceType.FRAGMENT, idToAttributeContract);
        }
        for (UpstreamSource upstreamSource : this.validatorInfo.getUpstreamSources().getSources()) {
            Map idToAttributeContracts;
            if (UpstreamSource.UpstreamSourceType.IDP_ADAPTER.equals((Object)upstreamSource.getType())) {
                IdpAuthnAdapterInstance adapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(upstreamSource.getId());
                idToAttributeContracts = authnSourceToAttributeContracts.getOrDefault((Object)SourceType.ADAPTER, new LinkedHashMap());
                idToAttributeContracts.put(upstreamSource.getId(), new ArrayList(adapter.getAttributeContract().getAllAttributeNames()));
                authnSourceToAttributeContracts.put(SourceType.ADAPTER, idToAttributeContracts);
                continue;
            }
            if (UpstreamSource.UpstreamSourceType.IDP_CONNECTION.equals((Object)upstreamSource.getType())) {
                IdpConnection conn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(upstreamSource.getId(), false);
                idToAttributeContracts = authnSourceToAttributeContracts.getOrDefault((Object)SourceType.IDP_CONNECTION, new LinkedHashMap());
                idToAttributeContracts.put(upstreamSource.getId(), new ArrayList(conn.getAttributeContract().getAllAttributeNames()));
                authnSourceToAttributeContracts.put(SourceType.IDP_CONNECTION, idToAttributeContracts);
                continue;
            }
            if (!UpstreamSource.UpstreamSourceType.FRAGMENT.equals((Object)upstreamSource.getType())) continue;
            PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(upstreamSource.getId());
            idToAttributeContracts = authnSourceToAttributeContracts.getOrDefault((Object)SourceType.FRAGMENT, new LinkedHashMap());
            idToAttributeContracts.put(upstreamSource.getId(), new ArrayList(fragment.getOutputContractAllAttributes()));
            authnSourceToAttributeContracts.put(SourceType.FRAGMENT, idToAttributeContracts);
        }
        HashMap<Object, List<String>> contextAttributes = new HashMap<Object, List<String>>();
        contextAttributes.put(null, Arrays.asList(SourceContextType.REQUEST.getId(), SourceContextType.CLIENT_IP.getId(), SourceContextType.OAUTH_CLIENT.getId(), SourceContextType.OAUTH_SCOPES.getId(), SourceContextType.SP_CONN_ENTITY_ID.getId(), SourceContextType.VIRTUAL_SERVER_ID.getId(), SourceContextType.SRI.getId()));
        authnSourceToAttributeContracts.put(SourceType.CONTEXT, contextAttributes);
        HashMap<String, List<String>> trackedHttpParameters = new HashMap<String, List<String>>();
        trackedHttpParameters.put("trackedparams", this.validatorInfo.getTrackedParams());
        authnSourceToAttributeContracts.put(SourceType.TRACKED_HTTP_PARAMS, trackedHttpParameters);
        HashMap extendedProperties = new HashMap();
        extendedProperties.put(null, new LinkedList(MgmtFactory.getClientSettingManager().getExtendedProperties().keySet()));
        authnSourceToAttributeContracts.put(SourceType.EXTENDED_PROPERTIES, extendedProperties);
        if (this.validatorInfo.getFragmentInfo() != null && this.validatorInfo.getFragmentInfo().getInputContract() != null) {
            HashMap fragmentInputs = new HashMap();
            fragmentInputs.put("Inputs", new LinkedList(this.validatorInfo.getFragmentInfo().getInputContract().getAllAttributeNames()));
            fragmentInputs.put("inputs", new LinkedList(this.validatorInfo.getFragmentInfo().getInputContract().getAllAttributeNames()));
            authnSourceToAttributeContracts.put(SourceType.INPUTS, fragmentInputs);
        }
        return authnSourceToAttributeContracts;
    }

    private Set<String> getSubstitutionValues(Map<SourceType, Map<String, List<String>>> authnSourceToAttributeContractNames) {
        HashSet<String> substitutionValues = new HashSet<String>();
        authnSourceToAttributeContractNames.forEach((sourceType, idToAttributesMap) -> {
            if (SourceType.CONTEXT.equals(sourceType)) {
                substitutionValues.addAll((Collection)idToAttributesMap.get(null));
            } else {
                String substitutionPrefix = null;
                switch (sourceType) {
                    case ADAPTER: {
                        substitutionPrefix = "ad.";
                        break;
                    }
                    case IDP_CONNECTION: {
                        substitutionPrefix = "idp.";
                        break;
                    }
                    case FRAGMENT: 
                    case INPUTS: {
                        substitutionPrefix = "fragment.";
                        break;
                    }
                    case EXTENDED_PROPERTIES: {
                        substitutionPrefix = "extproperties.";
                        break;
                    }
                    case TRACKED_HTTP_PARAMS: {
                        substitutionPrefix = "trackedparams.";
                        break;
                    }
                }
                if (substitutionPrefix != null) {
                    String subPrefix = substitutionPrefix;
                    idToAttributesMap.forEach((id, attributes) -> {
                        Object substitutionPrefixWithId = subPrefix;
                        if (SourceType.IDP_CONNECTION.equals(sourceType)) {
                            IdpConnection conn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(id, false);
                            substitutionPrefixWithId = subPrefix + conn.getEntityId() + ".";
                        } else if (!SourceType.EXTENDED_PROPERTIES.equals(sourceType) && !SourceType.TRACKED_HTTP_PARAMS.equals(sourceType)) {
                            substitutionPrefixWithId = subPrefix + id + ".";
                        }
                        for (String attribute : attributes) {
                            substitutionValues.add((String)substitutionPrefixWithId + attribute);
                        }
                    });
                }
            }
        });
        return substitutionValues;
    }

    private List<String> getPreviousAuthenticationSource(Map<SourceType, Map<String, List<String>>> authnSourceToAttributeContractNames) {
        Iterator<Map.Entry<String, List<String>>> authnSourceIterator;
        List<String> previousAttributeContractNames = Collections.emptyList();
        Iterator<Map.Entry<SourceType, Map<String, List<String>>>> authnTypeIterator = authnSourceToAttributeContractNames.entrySet().iterator();
        if (authnTypeIterator.hasNext() && (authnSourceIterator = authnTypeIterator.next().getValue().entrySet().iterator()).hasNext()) {
            previousAttributeContractNames = authnSourceIterator.next().getValue();
        }
        return previousAttributeContractNames;
    }

    protected void checkFailSuccessContextsPresent() {
        boolean hasSuccessContext = false;
        boolean hasFailContext = false;
        boolean displayFailSuccessError = true;
        AttributeRules attrRule = null;
        if (this.validatorInfo.getAction() instanceof AuthnSourcePolicyAction) {
            attrRule = ((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getAttributeRules();
        } else if (this.validatorInfo.getAction() instanceof FragmentPolicyAction) {
            attrRule = ((FragmentPolicyAction)this.validatorInfo.getAction()).getAttributeRules();
        }
        for (AuthenticationPolicyTreeNode child : this.validatorInfo.getChildren()) {
            if (child == null) continue;
            if (child.getAction() != null && child.getAction().getContext() != null) {
                if (child.getAction().getContext().equals("Success") || attrRule != null && !attrRule.isFallbackToSuccess()) {
                    hasSuccessContext = true;
                }
                if (!child.getAction().getContext().equals("Fail")) continue;
                hasFailContext = true;
                continue;
            }
            displayFailSuccessError = false;
        }
        if (displayFailSuccessError) {
            if (!hasSuccessContext || !hasFailContext) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_children_invalid_for_authn_source_action, this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getAction())));
            } else {
                String lastChild;
                if (!this.validatorInfo.getChildren().get(0).getAction().getContext().equals("Fail")) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_invalid_children_order_for_fail_authn_source_action, this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getAction())));
                }
                String lastItem = null;
                if (attrRule != null && attrRule.getItems() != null && attrRule.getItems().size() > 0) {
                    lastItem = attrRule.getItems().get(attrRule.getItems().size() - 1).getResult();
                }
                if (!(lastChild = this.validatorInfo.getChildren().get(this.validatorInfo.getChildren().size() - 1).getAction().getContext()).equals("Success") && !lastChild.equals(lastItem)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_invalid_childeren_order_for_success_authn_source_action, this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getAction())));
                }
            }
        }
    }
}

