/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;
import org.sourceid.saml20.metadata.Role;

public abstract class AbstractBackChannelValidator
extends AbstractValidator {
    protected Connection connection;

    public boolean isBackChannelAuthenticationNeeded() {
        BaseBrowserSso browserSso = this.connection.getBrowserSso();
        boolean isAnySsoSelected = false;
        boolean isArtifactSsoSloUsed = false;
        if (browserSso != null) {
            if (Protocol.WSFED == browserSso.getProtocol() || Role.IDP == this.connection.getType().getRole() && Protocol.isSaml1x(browserSso.getProtocol()) && browserSso.getIncomingBindings() != null && (browserSso.getIncomingBindings().contains((Object)Binding.REDIRECT) || browserSso.getIncomingBindings().contains((Object)Binding.SOAP))) {
                return false;
            }
            isAnySsoSelected = browserSso.isAnySsoSelected();
            isArtifactSsoSloUsed = browserSso.isArtifactSsoSloUsed();
        }
        if (Role.IDP == this.connection.getType().getRole()) {
            IdpConnection idpConn = (IdpConnection)this.connection;
            return isAnySsoSelected && (isArtifactSsoSloUsed || this.isSoapSlo() || this.isInboundArtifact() || this.isInboundSoap()) || idpConn.getAttributeQuery() != null || idpConn.getInboundProvisioning() != null;
        }
        SpConnection spConn = (SpConnection)this.connection;
        return isAnySsoSelected && (this.isOutboundArtifactBindingUsed() || this.isSloArtifactBindingUsed() || this.isInboundArtifact() || this.isInboundSoap() || this.isSoapSlo()) || spConn.getAttributeQuery() != null;
    }

    protected boolean isSoapSlo() {
        if (this.connection.getBrowserSso() == null || this.connection.getBrowserSso().getSloServiceEndpoints() == null) {
            return false;
        }
        return this.connection.getBrowserSso().isBindingSloUsed(Binding.SOAP);
    }

    protected boolean isInboundArtifact() {
        if (this.connection.getType().getRole() == Role.IDP) {
            return this.hasIncomingBinding(Binding.ARTIFACT);
        }
        BaseBrowserSso browserSso = this.connection.getBrowserSso();
        if (browserSso != null && (browserSso.isAnySloSelected() || !browserSso.isAnySloSelected() && browserSso.isProfileSelected(Profile.SP_INITIATED_SSO))) {
            return this.hasIncomingBinding(Binding.ARTIFACT);
        }
        return false;
    }

    protected boolean isInboundSoap() {
        BaseBrowserSso browserSso = this.connection.getBrowserSso();
        if (browserSso != null && browserSso.isProfileSelected(Profile.SP_INITIATED_SSO)) {
            return this.hasIncomingBinding(Binding.SOAP);
        }
        return false;
    }

    protected boolean isOutboundArtifactBindingUsed() {
        if (this.connection.getBrowserSso() == null || this.connection.getBrowserSso().getBaseSsoServiceEndpoints() == null) {
            return false;
        }
        return this.connection.getBrowserSso().isBindingSsoUsed(Binding.ARTIFACT);
    }

    protected boolean isSloArtifactBindingUsed() {
        if (this.connection.getBrowserSso() == null || this.connection.getBrowserSso().getSloServiceEndpoints() == null) {
            return false;
        }
        return this.connection.getBrowserSso().isBindingSloUsed(Binding.ARTIFACT);
    }

    private boolean hasIncomingBinding(Binding binding) {
        if (this.connection.getBrowserSso() != null) {
            if (this.connection.getBrowserSso().getProtocol() == Protocol.SAML20 || this.connection.getType().getRole() == Role.IDP && Protocol.isSaml1x(this.connection.getBrowserSso().getProtocol())) {
                Set<Binding> incomingBindings = this.connection.getBrowserSso().getIncomingBindings();
                return incomingBindings != null && incomingBindings.contains((Object)binding);
            }
            return true;
        }
        return false;
    }

    protected boolean isArtifactSsoSlo() {
        return this.isOutboundArtifactBindingUsed() || this.isSloArtifactBindingUsed();
    }
}

