/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.CredentialsPath;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class AbstractDecryptionKeyPairValidator
extends CompositeValidator {
    protected ConnectionCredentials connCreds;
    private boolean fullValidationPath;

    public AbstractDecryptionKeyPairValidator(ConnectionCredentials connCreds, boolean fullValidationPath) {
        this.connCreds = connCreds;
        this.fullValidationPath = fullValidationPath;
    }

    @Override
    public boolean validate() {
        if (this.connCreds == null) {
            return !this.hasErrors();
        }
        if (!this.isDecryptionRequired()) {
            if (this.connCreds.getDecryptionKeyPairRef() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.decryption_key_pair_not_required, CredentialsPath.getDecryptionKeyPair(this.fullValidationPath), new Object[]{"primary"}));
            }
            if (this.connCreds.getSecondaryDecryptionKeyPairRef() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.decryption_key_pair_not_required, CredentialsPath.getSecondaryDecryptionKeyPair(this.fullValidationPath), new Object[]{"secondary"}));
            }
            return !this.hasErrors();
        }
        ResourceLink decryptionKeyCert = this.connCreds.getDecryptionKeyPairRef();
        ResourceLink secondaryDecryptionKeyCert = this.connCreds.getSecondaryDecryptionKeyPairRef();
        if (decryptionKeyCert == null || decryptionKeyCert.getId() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.decryption_key_pair_required, CredentialsPath.getDecryptionKeyPairId(this.fullValidationPath)));
        } else if (secondaryDecryptionKeyCert != null && decryptionKeyCert.getId().equals(secondaryDecryptionKeyCert.getId())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.primary_and_secondary_decryption_key_same, CredentialsPath.getSecondaryDecryptionKeyPairId(this.fullValidationPath)));
        }
        if (this.hasErrors()) {
            return false;
        }
        this.validateDecryptionKeyCert(decryptionKeyCert, "primary", CredentialsPath.getDecryptionKeyPairId(this.fullValidationPath));
        this.validateDecryptionKeyCert(secondaryDecryptionKeyCert, "secondary", CredentialsPath.getSecondaryDecryptionKeyPairId(this.fullValidationPath));
        return !this.hasErrors();
    }

    protected void validateDecryptionKeyCert(ResourceLink decryptionKeyCert, String primaryOrSecondary, String path) {
        if (decryptionKeyCert != null) {
            String decryptionKeyCertId = decryptionKeyCert.getId();
            PkCert pkCert = MgmtFactory.getDsigPkCertManager().getPkCert(decryptionKeyCertId);
            if (pkCert == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.decryption_key_pair_not_found, path, new Object[]{decryptionKeyCertId, primaryOrSecondary}));
            } else if (!pkCert.getX509Certificate().getPublicKey().getAlgorithm().equals("RSA")) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.decryption_key_pair_not_rsa, path, new Object[]{primaryOrSecondary}));
            }
        }
    }

    protected abstract boolean isDecryptionRequired();
}

