/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SsoServiceEndpoint;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.PartnerUrlValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.metadata.Role;

public abstract class AbstractSsoServiceEndpointValidator
extends AbstractValidator {
    protected final List<? extends SsoServiceEndpoint> ssoEndpoints;
    protected final boolean spInitSsoEnabled;
    protected final boolean isBaseUrlDefined;
    protected final Protocol protocol;
    protected final Role role;

    public AbstractSsoServiceEndpointValidator(List<? extends SsoServiceEndpoint> ssoEndpoints, boolean spInitSsoEnabled, boolean isBaseUrlDefined, Protocol protocol, Role role) {
        this.ssoEndpoints = ssoEndpoints;
        this.spInitSsoEnabled = spInitSsoEnabled;
        this.isBaseUrlDefined = isBaseUrlDefined;
        this.protocol = protocol;
        this.role = role;
    }

    public boolean validate() {
        int initNumErrors = this.getErrors().size();
        if (this.ssoEndpoints == null || this.ssoEndpoints.isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_empty, ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role)));
        } else if (this.validateSsoServiceEndpointListNullEntries()) {
            boolean bindingError = false;
            boolean missingUrlError = false;
            int i = 0;
            if (this.protocol == Protocol.WSFED) {
                if (this.ssoEndpoints.size() > 1) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_ws_fed_exceeded_limit, ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role)));
                    bindingError = true;
                }
                this.checkWsFedEndpoints(this.ssoEndpoints);
            }
            for (SsoServiceEndpoint ssoServiceEndpoint : this.ssoEndpoints) {
                if (this.protocol == Protocol.SAML20 && ssoServiceEndpoint.getBinding() == null && !bindingError) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_binding_missing, ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role)));
                    bindingError = true;
                }
                if (this.protocol == Protocol.WSFED) {
                    if (ssoServiceEndpoint.getBinding() != null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_binding_not_required, ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role)));
                        bindingError = true;
                    }
                } else if (!Protocol.isSaml1x(this.protocol) && !this.getSupportedBindings().contains((Object)ssoServiceEndpoint.getBinding())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_invalid_binding, ConnectionPaths.getSsoServiceEndpointsBindingPath(Role.SP, i), new Object[]{ssoServiceEndpoint.getBinding(), StringUtils.join(this.getSupportedBindings(), (String)",")}));
                }
                if (ssoServiceEndpoint.getUrl() == null) {
                    if (!missingUrlError) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_url_missing, ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role)));
                        missingUrlError = true;
                    }
                } else {
                    String fieldPath = ConnectionPaths.getSsoServiceEndpointsUrlPath(this.role, i);
                    PartnerUrlValidator urlValidator = PartnerUrlValidatorFactory.getBrowserSsoEndpointUrlValidator(ssoServiceEndpoint.getUrl(), this.isBaseUrlDefined, fieldPath, this.protocol == Protocol.WSFED);
                    urlValidator.validate();
                    this.getErrors().addAll(urlValidator.getErrors());
                }
                ++i;
            }
        }
        return initNumErrors == this.getErrors().size();
    }

    private boolean validateSsoServiceEndpointListNullEntries() {
        int i = 0;
        for (SsoServiceEndpoint ssoServiceEndpoint : this.ssoEndpoints) {
            if (ssoServiceEndpoint == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, ConnectionPaths.getSsoServiceEndpointsPropertyPath(this.role, i)));
            }
            ++i;
        }
        return !this.hasErrors();
    }

    protected void checkWsFedEndpoints(List<? extends SsoServiceEndpoint> endpoints) {
        for (int i = 0; i < endpoints.size(); ++i) {
            SsoServiceEndpoint endpoint = endpoints.get(i);
            if (endpoint.getBinding() == null) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getSsoServiceEndpointsBindingPath(Role.SP, i), new Object[]{"binding"}));
        }
    }

    protected abstract Set<Binding> getSupportedBindings();
}

