/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AccessTokenManagerMapping;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.IdpOAuthAttributeContract;
import com.pingidentity.admin.api.model.IdpOAuthGrantAttributeMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.SpUrlMappingPaths;
import com.pingidentity.admin.api.model.fieldpaths.oauth.AccessTokenMappingPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ListNotEmptyValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OnlyOneAttributeSourceValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.OAuthAssertionGrantAttributeContract;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class AccessTokenManagerMappingValidator
extends BaseAttributeDataSourceValidator {
    private final List<AccessTokenManagerMapping> apiMappings;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final BearerAccessTokenMgmtPluginManager accessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();

    public AccessTokenManagerMappingValidator(IdpOAuthGrantAttributeMapping idpOAuthGrantAttributeMapping, ValidatorContext context) {
        super(context);
        this.apiMappings = idpOAuthGrantAttributeMapping.getAccessTokenManagerMappings();
        this.addValidator((Validator)new ListNotEmptyValidator(this.apiMappings, ApiMessageKey.oauth_access_token_management_missing_mappings, ConnectionPaths.getIdpOAuthGrantAttributeMapping()));
        UniqueEntriesValidator.UniqueKeyGetter<AccessTokenManagerMapping> accessTokenManagerMappingKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<AccessTokenManagerMapping>(){

            @Override
            public String getKey(AccessTokenManagerMapping object) {
                if (object.getAccessTokenManagerRef() != null && object.getAccessTokenManagerRef().getId() != null) {
                    return object.getAccessTokenManagerRef().getId();
                }
                return null;
            }
        };
        this.addValidator((Validator)new UniqueEntriesValidator<AccessTokenManagerMapping>(accessTokenManagerMappingKeyGetter, this.apiMappings, AccessTokenMappingPaths.getAccessTokenManagerId(), ApiMessageKey.oauth_access_token_management_access_token_manager_exists));
        int mappingCnt = 0;
        for (AccessTokenManagerMapping mapping : this.apiMappings) {
            BearerAccessTokenMgmtPluginInstance tokenManager;
            ExpressionManager expressionManager;
            this.addValidator((Validator)new ResourceIdValidator(mapping.getAccessTokenManagerRef(), "Access Token Manager ref ID", ConnectionPaths.getIdpAccessTokenManagerLinkPath(mappingCnt)));
            if (mapping.getAccessTokenManagerRef() != null && StringUtils.isNotBlank((String)mapping.getAccessTokenManagerRef().getId())) {
                this.addValidator((Validator)new PluginExistsValidator((PluginManager<?, ?>)this.accessTokenMgmtPluginMgr, mapping.getAccessTokenManagerRef().getId(), ConnectionPaths.getIdpAccessTokenManagerLinkPath(mappingCnt) + "." + AccessTokenMappingPaths.getId(), ApiMessageKey.oauth_access_token_management_invalid_access_token_manager_id));
            }
            AttributeSetSourceTypeValidatorBuilder assertionSourceTypeBuilder = this.createAssertionValBuilder(idpOAuthGrantAttributeMapping.getIdpOAuthAttributeContract());
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_CLIENT_METADATA), new ExtendedMetadataSourceTypeValidatorBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
            rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
            if (assertionSourceTypeBuilder != null) {
                rootSources.put(new SourceTypeIdKey(SourceType.ASSERTION), assertionSourceTypeBuilder);
            }
            if ((expressionManager = ExpressionManager.getInstance()).isEvaluateExpressionsOn()) {
                rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
            }
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            validSources.putAll(rootSources);
            validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE), this.createDsValBuilder(SourceType.LDAP_DATA_STORE, mapping));
            validSources.put(new SourceTypeIdKey(SourceType.JDBC_DATA_STORE), this.createDsValBuilder(SourceType.JDBC_DATA_STORE, mapping));
            validSources.put(new SourceTypeIdKey(SourceType.CUSTOM_DATA_STORE), this.createDsValBuilder(SourceType.CUSTOM_DATA_STORE, mapping));
            if (mapping.getAccessTokenManagerRef() != null && (tokenManager = (BearerAccessTokenMgmtPluginInstance)this.bearerAccessTokenMgmtPluginMgr.getInstance(mapping.getAccessTokenManagerRef().getId())) != null) {
                HashSet<String> validAttributeNames = new HashSet<String>();
                if (tokenManager.getAttributeContract() != null) {
                    validAttributeNames.addAll(tokenManager.getAttributeContract().getAllAttributeNames());
                }
                if (tokenManager.getTokenEndpointAttributeContract() != null) {
                    validAttributeNames.addAll(tokenManager.getTokenEndpointAttributeContract().getAllAttributeNames());
                }
                this.addValidator((Validator)new AttributeMappingValidator(mapping, validAttributeNames, assertionSourceTypeBuilder.getAssertionAttributes(), "persistent grant or authentication context", validSources, ConnectionPaths.getIdpAccessTokenManagerBasePath(mappingCnt), this.getContext()));
            }
            this.addValidator((Validator)new OnlyOneAttributeSourceValidator(mapping.getAttributeSources().size(), ApiMessageKey.oauth_access_token_mapping_multiple_attribute_sources, ConnectionPaths.getOAuthGrantDataSources()));
            ++mappingCnt;
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.apiMappings.isEmpty() && this.accessTokenMgmtPluginMgr.getInstances().size() > 1) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_attribute_mapping_required, SpUrlMappingPaths.getRef()));
        }
        return !this.hasErrors();
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForAccessTokenMapping());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private AttributeSetSourceTypeValidatorBuilder createAssertionValBuilder(IdpOAuthAttributeContract contract) {
        HashSet<String> assertionAttributes = new HashSet<String>();
        OAuthAssertionGrantAttributeContract domainAssertionContract = new OAuthAssertionGrantAttributeContract();
        assertionAttributes.addAll(domainAssertionContract.getImmutableAttributeNames());
        for (IdpBrowserSsoAttribute exAttr : contract.getExtendedAttributes()) {
            if (exAttr.getName() == null) continue;
            assertionAttributes.add(exAttr.getName());
        }
        return new AttributeSetSourceTypeValidatorBuilder(assertionAttributes, SourceType.ASSERTION);
    }
}

