/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.AccessTokenMappingPaths;
import com.pingidentity.admin.api.model.oauth.AccessTokenMapping;
import com.pingidentity.admin.api.model.oauth.AccessTokenMappingContext;
import com.pingidentity.admin.api.model.oauth.AccessTokenMappingType;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.PersistentGrantSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;

public class AccessTokenMappingValidator
extends BaseAttributeDataSourceValidator {
    private final AccessTokenMapping mapping;
    private final boolean createMode;
    private String tokenManagerId;
    private AttributeContract authnContextContract;
    private SourceType authnContextSourceType;
    private String authnContextId;
    private final ContextUtil contextUtil = new ContextUtil();
    private final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final TokenExchangeProcessorPolicyManager processorPolicyMgr = MgmtFactory.getTokenExchangeProcessorPolicyManager();

    public AccessTokenMappingValidator(AccessTokenMapping mapping, ValidatorContext context) {
        super(context);
        this.mapping = mapping;
        boolean bl = this.createMode = !context.isUpdateRequest();
        if (mapping.getAccessTokenManagerRef() == null || mapping.getAccessTokenManagerRef().getId() == null) {
            mapping.setAccessTokenManagerRef(new ResourceLink("default"));
        }
        this.tokenManagerId = mapping.getAccessTokenManagerRef().getId();
    }

    @Override
    public boolean validate() {
        this.validateContext();
        if (!this.hasErrors()) {
            this.addAdditionalValidators();
        }
        super.validate();
        return !this.hasErrors();
    }

    private void addAdditionalValidators() {
        ExpressionManager expressionManager;
        PersistentGrantSourceTypeValidatorBuilder persistentGrantSourceTypeValidatorBuilder = this.createPersistentGrantValBuilder(this.authnContextId);
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_CLIENT_METADATA), new ExtendedMetadataSourceTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        if (this.authnContextId != null && !"client_credentials".equals(this.authnContextId)) {
            rootSources.put(new SourceTypeIdKey(SourceType.OAUTH_PERSISTENT_GRANT), persistentGrantSourceTypeValidatorBuilder);
            if (this.authnContextSourceType != null) {
                rootSources.put(new SourceTypeIdKey(this.authnContextSourceType), this.createAuthnContextBuilder());
            }
        }
        if ((expressionManager = ExpressionManager.getInstance()).isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        validSources.putAll(rootSources);
        if (this.mapping.getAttributeSources() != null && this.mapping.getAttributeSources().size() > 1) {
            int index = 0;
            for (AttributeSource attributeSource : this.mapping.getAttributeSources()) {
                this.addValidator((Validator)new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", AccessTokenMappingPaths.getAttributeSourceId(index)));
                ++index;
            }
        }
        this.mapDataStoreTypesToDsValidators(this.mapping, validSources);
        BearerAccessTokenMgmtPluginInstance tokenManager = (BearerAccessTokenMgmtPluginInstance)this.bearerAccessTokenMgmtPluginMgr.getInstance(this.tokenManagerId);
        if (tokenManager != null) {
            HashSet<String> validAttributeNames = new HashSet<String>();
            validAttributeNames.addAll(tokenManager.getAttributeContract().getAllAttributeNames());
            validAttributeNames.addAll(tokenManager.getTokenEndpointAttributeContract().getAllAttributeNames());
            HashSet<String> substitutionVars = new HashSet<String>(persistentGrantSourceTypeValidatorBuilder.getExposedSubstitutionVariables());
            substitutionVars.addAll(this.getAuthnContextSubstitutionVars());
            this.addValidator((Validator)new AttributeMappingValidator(this.mapping, validAttributeNames, substitutionVars, "persistent grant or authentication context", validSources, "", this.getContext()));
        }
    }

    private void validateContext() {
        String contextRefId;
        ConfigurablePluginInstance tokenManager = this.bearerAccessTokenMgmtPluginMgr.getInstance(this.tokenManagerId);
        if (tokenManager == null || !tokenManager.getId().equals(this.tokenManagerId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_invalid_token_manager_id, AccessTokenMappingPaths.getAccessTokenManagerId()));
            return;
        }
        AccessTokenMappingContext context = this.mapping.getContext();
        if (context == null) {
            context = new AccessTokenMappingContext();
            context.setType(AccessTokenMappingType.DEFAULT);
            this.mapping.setContext(context);
        }
        if (context.getType() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_context_type_required, AccessTokenMappingPaths.getContextType()));
            return;
        }
        String string = contextRefId = context.getContextRef() != null ? context.getContextRef().getId() : null;
        if (context.getType() != AccessTokenMappingType.DEFAULT && context.getType() != AccessTokenMappingType.CLIENT_CREDENTIALS && contextRefId == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_context_id_required, AccessTokenMappingPaths.getContextRefId()));
            return;
        }
        this.authnContextId = AccessTokenMappingType.toContextId(context.getType(), contextRefId);
        String mappingId = org.sourceid.oauth20.domain.AccessTokenMapping.makeId((String)this.authnContextId, (String)this.tokenManagerId);
        if (this.isCreateMode()) {
            if (this.authzServerManager.getUserKeyToAccessTokenMapping(mappingId) != null || this.authzServerManager.getClientCredsToAccessTokenMapping(mappingId) != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_exists, AccessTokenMappingPaths.getContext()));
            }
        } else if (!this.mapping.getId().equals(mappingId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_id_mismatch, AccessTokenMappingPaths.getContext()));
        }
        if (AccessTokenMappingType.CLIENT_CREDENTIALS == context.getType()) {
            this.authnContextContract = MgmtFactory.getAuthzServerManager().getClientCredentialsContract();
        } else if (context.getType() != AccessTokenMappingType.DEFAULT) {
            ContextUtil.Ctx ctx = this.contextUtil.split(this.authnContextId);
            String ctxId = ctx.getOAuthSourceId().getRealId();
            switch (context.getType()) {
                case PCV: {
                    if (!this.getSourcePluginIds(this.authzServerManager.getPwdCredValidatorToUserKeyMappings()).contains(ctxId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_invalid_context_id, AccessTokenMappingPaths.getContextRefId()));
                        break;
                    }
                    ConfigurablePluginInstance instance = MgmtFactory.getCredentialValidatorManager().getInstance(ctxId);
                    if (instance == null) break;
                    this.authnContextContract = instance.getAttributeContract();
                    this.authnContextSourceType = SourceType.PASSWORD_CREDENTIAL_VALIDATOR;
                    break;
                }
                case IDP_ADAPTER: {
                    if (!this.isIdPEnabled() || !this.getSourcePluginIds(this.authzServerManager.getAdapterToUserKeyMappings()).contains(ctxId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_invalid_context_id, AccessTokenMappingPaths.getContextRefId()));
                        break;
                    }
                    ConfigurablePluginInstance instance = MgmtFactory.getIdpAdapterManager().getInstance(ctxId);
                    if (instance == null) break;
                    this.authnContextContract = instance.getAttributeContract();
                    this.authnContextSourceType = SourceType.ADAPTER;
                    break;
                }
                case IDP_CONNECTION: {
                    IdpConnection idpConnection = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(ctxId, false);
                    if (!this.isSPEnabled() || idpConnection == null || !idpConnection.hasSsoToOAuthAttrMapping()) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_invalid_context_id, AccessTokenMappingPaths.getContextRefId()));
                        break;
                    }
                    this.authnContextContract = idpConnection.getAttributeContract();
                    this.authnContextSourceType = SourceType.IDP_CONNECTION;
                    break;
                }
                case AUTHENTICATION_POLICY_CONTRACT: {
                    C2cContract apc = MgmtFactory.getC2cContractManager().getContract(ctxId);
                    if (apc == null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_invalid_context_id, AccessTokenMappingPaths.getContextRefId()));
                        break;
                    }
                    this.authnContextContract = apc;
                    this.authnContextSourceType = SourceType.AUTHENTICATION_POLICY_CONTRACT;
                    break;
                }
                case TOKEN_EXCHANGE_PROCESSOR_POLICY: {
                    if (this.processorPolicyMgr.getTokenExchangeProcessorPolicies() == null || this.processorPolicyMgr.getTokenExchangeProcessorPolicies().getPolicies().isEmpty() || !this.processorPolicyMgr.getTokenExchangeProcessorPolicies().getPolicyIds().contains(ctxId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_invalid_context_id, AccessTokenMappingPaths.getContextRefId()));
                        break;
                    }
                    TokenExchangeProcessorPolicy instance = this.processorPolicyMgr.getTokenExchangeProcessorPolicies().getPolicy(contextRefId);
                    if (instance == null) break;
                    this.authnContextContract = instance.getContract();
                    this.authnContextSourceType = SourceType.TOKEN_EXCHANGE_PROCESSOR_POLICY;
                    break;
                }
                default: {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_access_token_mapping_invalid_context_id, AccessTokenMappingPaths.getContextRefId()));
                }
            }
        }
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForAccessTokenMapping());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private PersistentGrantSourceTypeValidatorBuilder createPersistentGrantValBuilder(String authnContextId) {
        return new PersistentGrantSourceTypeValidatorBuilder(authnContextId);
    }

    private AttributeSetSourceTypeValidatorBuilder createAuthnContextBuilder() {
        return new AttributeSetSourceTypeValidatorBuilder(this.authnContextContract.getAllAttributeNames(), this.authnContextSourceType, UserKeyToAccessTokenMapping.getContextAttrPrefix((String)this.authnContextId));
    }

    private Set<String> getAuthnContextSubstitutionVars() {
        HashSet<String> result = new HashSet<String>();
        if (this.authnContextContract != null) {
            result.addAll(UserKeyToAccessTokenMapping.getContextAttributeIds((String)this.authnContextId, (AttributeContract)this.authnContextContract));
        }
        return result;
    }

    private boolean isCreateMode() {
        return this.createMode;
    }

    private boolean isSPEnabled() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableSP();
    }

    private boolean isIdPEnabled() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableIdP();
    }

    private Set<String> getSourcePluginIds(Collection<PluginToUserKeyAttrMapping> mappings) {
        HashSet<String> sourcePluginIds = new HashSet<String>();
        for (PluginToUserKeyAttrMapping adapterMapping : mappings) {
            sourcePluginIds.add(adapterMapping.getSourcePluginId());
        }
        return sourcePluginIds;
    }
}

