/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AccountManagementSettings;
import com.pingidentity.admin.api.model.SaasAccountStatusAlgorithm;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class AccountManagementSettingsValidator
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private AccountManagementSettings accountManagementSettings;
    private int index;
    private LdapInfo.LdapType ldapType;

    AccountManagementSettingsValidator(int index, AccountManagementSettings accountManagementSettings, LdapInfo.LdapType ldapType) {
        this.accountManagementSettings = accountManagementSettings;
        this.index = index;
        this.ldapType = ldapType;
        this.addValidator((Validator)new NotBlankValidator(accountManagementSettings.getAccountStatusAttributeName(), ConnectionPaths.OutboundProvisionPaths.getAccountStatusAttributeName(index), ConnectionPaths.OutboundProvisionPaths.getAccountStatusAttributeName(index)));
        this.addValidator((Validator)new NotNullValidator((Object)accountManagementSettings.getAccountStatusAlgorithm(), ConnectionPaths.OutboundProvisionPaths.getAccountStatusAlgorithm(index), ConnectionPaths.OutboundProvisionPaths.getAccountStatusAlgorithm(index)));
    }

    @Override
    public boolean validate() {
        super.validate();
        if (SaasAccountStatusAlgorithm.ACCOUNT_STATUS_ALGORITHM_AD == this.accountManagementSettings.getAccountStatusAlgorithm()) {
            if (LdapInfo.LdapType.ActiveDirectory != this.ldapType) {
                this.appendError(this.errorFactory.create(ApiMessageKey.outbound_provisioning_account_status_algo_invalid, ConnectionPaths.OutboundProvisionPaths.getFlagComparisonValue(this.index), new Object[]{SaasAccountStatusAlgorithm.ACCOUNT_STATUS_ALGORITHM_AD}));
            } else if (StringUtils.isNotBlank((String)this.accountManagementSettings.getFlagComparisonValue())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.outbound_provisioning_flag_comparison_value_required, ConnectionPaths.OutboundProvisionPaths.getFlagComparisonValue(this.index), new Object[]{SaasAccountStatusAlgorithm.ACCOUNT_STATUS_ALGORITHM_FLAG}));
            }
        } else if (SaasAccountStatusAlgorithm.ACCOUNT_STATUS_ALGORITHM_FLAG == this.accountManagementSettings.getAccountStatusAlgorithm() && StringUtils.isBlank((String)this.accountManagementSettings.getFlagComparisonValue())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.outbound_provisioning_flag_comparison_value_required, ConnectionPaths.OutboundProvisionPaths.getFlagComparisonValue(this.index), new Object[]{SaasAccountStatusAlgorithm.ACCOUNT_STATUS_ALGORITHM_FLAG}));
        }
        return !this.hasErrors();
    }
}

