/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.service.impl.UrlMatchingServiceAdminApiCorsImpl;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.HashSet;
import java.util.List;

public class AdminApiCorsSettingsValidator
extends CompositeValidator {
    private final List<String> allowedOrigins;
    public static final String ALLOWED_ORIGINS_LIST_FIELD_PATH = "allowedOriginsList";

    public AdminApiCorsSettingsValidator(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.hasErrors()) {
            return false;
        }
        HashSet<String> set = new HashSet<String>();
        UrlMatchingServiceAdminApiCorsImpl urlMatchingService = new UrlMatchingServiceAdminApiCorsImpl();
        for (int i = 0; i < this.allowedOrigins.size(); ++i) {
            String origin = this.allowedOrigins.get(i);
            if (!urlMatchingService.isValidUrlPattern(origin)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_api_cors_origin_invalid, "allowedOriginsList[" + i + "]", new Object[]{origin}));
                continue;
            }
            if (set.add(origin)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_api_cors_origin_duplicate_entry, "allowedOriginsList[" + i + "]", new Object[]{origin}));
        }
        return !this.hasErrors();
    }
}

