/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AdministrativeAccount;
import com.pingidentity.admin.api.model.AdministrativeRoleType;
import com.pingidentity.admin.api.model.fieldpaths.AdministrativeAccountPaths;
import com.pingidentity.admin.api.validator.EmailValidator;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class AdministrativeAccountValidator
extends AbstractValidator {
    private boolean isCreate;
    private AdministrativeAccount adminAccount;
    private String username;
    private AdministrativeUser currentUser;
    private ValidatorContext validatorContext;
    private static final AdminUserManager adminUserManager = MgmtFactory.getNativeAdminUserManager();

    public AdministrativeAccountValidator(AdministrativeAccount adminAccount, String username, boolean isCreateAccount, ValidatorContext validatorContext) {
        this.isCreate = isCreateAccount;
        this.adminAccount = adminAccount;
        this.username = username;
        this.validatorContext = validatorContext;
    }

    public boolean validate() {
        if (StringUtils.isEmpty((String)this.adminAccount.getUsername())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, AdministrativeAccountPaths.getUsername(), new Object[]{AdministrativeAccountPaths.getUsername()}));
            return !this.hasErrors();
        }
        Collection adminAccounts = adminUserManager.getUsers();
        if (!(this.validatorContext != null && this.validatorContext.isBulkConfigRequest() || adminAccounts != null && !adminAccounts.isEmpty() && (this.isCreate || adminAccounts.size() != 1))) {
            if (this.adminAccount.isAuditor() || this.adminAccount.getRoles() == null || !this.adminAccount.getRoles().contains((Object)AdministrativeRoleType.USER_ADMINISTRATOR)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_user_admin_not_enabled, AdministrativeAccountPaths.getRoles(), new Object[]{AdministrativeAccountPaths.getRoles()}));
            }
            if (!this.adminAccount.isActive()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_user_admin_inactive, AdministrativeAccountPaths.getActive(), new Object[]{AdministrativeAccountPaths.getActive()}));
            }
        }
        if (this.adminAccount.isAuditor()) {
            if (this.adminAccount.getRoles() != null && !this.adminAccount.getRoles().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_auditor_with_roles, AdministrativeAccountPaths.getAuditor(), new Object[]{AdministrativeAccountPaths.getAuditor()}));
            }
        } else if (this.adminAccount.getRoles() == null || this.adminAccount.getRoles().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_auditor_with_roles, AdministrativeAccountPaths.getRoles(), new Object[]{AdministrativeAccountPaths.getRoles()}));
        } else if (!this.adminAccount.getRoles().contains((Object)AdministrativeRoleType.ADMINISTRATOR) && this.adminAccount.getRoles().contains((Object)AdministrativeRoleType.EXPRESSION_ADMINISTRATOR)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_expression_admin_without_admin_role, AdministrativeAccountPaths.getRoles(), new Object[]{AdministrativeAccountPaths.getRoles()}));
        }
        if (this.adminAccount.getRoles().contains((Object)AdministrativeRoleType.DATA_COLLECTION_ADMINISTRATOR)) {
            if (!this.adminAccount.getRoles().contains((Object)AdministrativeRoleType.ADMINISTRATOR)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_data_collection_without_admin_role, AdministrativeAccountPaths.getRoles(), new Object[]{AdministrativeAccountPaths.getRoles()}));
            }
            if (!this.adminAccount.getRoles().contains((Object)AdministrativeRoleType.CRYPTO_ADMINISTRATOR)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_data_collection_without_crypto_admin_role, AdministrativeAccountPaths.getRoles(), new Object[]{AdministrativeAccountPaths.getRoles()}));
            }
            if (!this.adminAccount.getRoles().contains((Object)AdministrativeRoleType.USER_ADMINISTRATOR)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_data_collection_without_user_admin_role, AdministrativeAccountPaths.getRoles(), new Object[]{AdministrativeAccountPaths.getRoles()}));
            }
        }
        if (StringUtils.isEmpty((String)this.adminAccount.getEmailAddress())) {
            if (MgmtFactory.getNotificationMgr().getNotificationSettings().isEnableAccountChangesNotification()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_email_required, AdministrativeAccountPaths.getEmailAddress(), new Object[]{AdministrativeAccountPaths.getEmailAddress()}));
            }
        } else {
            EmailValidator emailValidator = new EmailValidator(this.adminAccount.getEmailAddress(), ApiMessageKey.admin_account_email_invalid, AdministrativeAccountPaths.getEmailAddress());
            if (!emailValidator.validate()) {
                this.appendErrors(emailValidator.getErrors());
            }
        }
        if (this.isCreate) {
            if (StringUtils.isEmpty((String)this.username)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, AdministrativeAccountPaths.getUsername(), new Object[]{AdministrativeAccountPaths.getUsername()}));
            } else if (adminUserManager.getUser(this.adminAccount.getUsername()) != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_already_exists, AdministrativeAccountPaths.getUsername(), new Object[]{AdministrativeAccountPaths.getUsername()}));
            }
            if (StringUtils.isEmpty((String)this.adminAccount.getPassword()) && StringUtils.isEmpty((String)this.adminAccount.getEncryptedPassword())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, AdministrativeAccountPaths.getPassword(), new Object[]{AdministrativeAccountPaths.getPassword()}));
            }
            this.validatePassword();
            this.validateEncryptedPassword(true);
        } else {
            if (!StringUtils.isEmpty((String)this.username) && !this.username.equalsIgnoreCase(this.adminAccount.getUsername())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_cannot_update_username, AdministrativeAccountPaths.getUsername(), new Object[]{AdministrativeAccountPaths.getUsername()}));
            } else if (this.isSelfRequest() && !this.adminAccount.isActive()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_self_account_inactive, AdministrativeAccountPaths.getUsername(), new Object[]{AdministrativeAccountPaths.getUsername()}));
            }
            if (StringUtils.isEmpty((String)this.adminAccount.getEncryptedPassword())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, AdministrativeAccountPaths.getEncryptedPassword(), new Object[]{AdministrativeAccountPaths.getEncryptedPassword()}));
            } else {
                this.validateEncryptedPassword(false);
            }
            if (StringUtils.isNotEmpty((String)this.adminAccount.getPassword())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, AdministrativeAccountPaths.getPassword(), new Object[]{AdministrativeAccountPaths.getPassword()}));
            }
        }
        return !this.hasErrors();
    }

    private void validateEncryptedPassword(boolean isCreate) {
        if (StringUtils.isNotEmpty((String)this.adminAccount.getEncryptedPassword())) {
            String[] hashSalt;
            AdministrativeUser user;
            String decrypted = EncryptedFieldValidator.decryptCiphertext(this.adminAccount.getEncryptedPassword());
            if (decrypted == null || !HashedPassword.isEncodedText((String)decrypted) && !decrypted.contains(":")) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_invalid_password, AdministrativeAccountPaths.getEncryptedPassword(), new Object[]{AdministrativeAccountPaths.getEncryptedPassword()}));
            } else if (!(isCreate || decrypted.equals((user = adminUserManager.getUser(this.username)).getHash()) || (hashSalt = decrypted.split(":")).length != 0 && hashSalt[0].equals(user.getHash()))) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.admin_account_invalid_password, AdministrativeAccountPaths.getEncryptedPassword(), new Object[]{AdministrativeAccountPaths.getEncryptedPassword()}));
            }
        }
    }

    private void validatePassword() {
        PasswordValidator passwordValidator;
        if (StringUtils.isNotEmpty((String)this.adminAccount.getPassword()) && !(passwordValidator = new PasswordValidator(this.adminAccount.getPassword(), AdministrativeAccountPaths.getPassword(), "Password")).validate()) {
            this.appendErrors(passwordValidator.getErrors());
        }
    }

    public boolean isSelfRequest() {
        return this.currentUser != null && this.currentUser.getUserName().equalsIgnoreCase(this.username);
    }

    public void setCurrentUser(AdministrativeUser currentUser) {
        this.currentUser = currentUser;
    }
}

