/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ApcMappingPolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.validator.AbstractActionValidator;
import com.pingidentity.admin.api.validator.AbstractAuthnPolicyAttributeMappingValidator;
import com.pingidentity.admin.api.validator.AuthnPolicyApcAttributeMappingValidator;
import com.pingidentity.admin.api.validator.FragmentApcAttributeMappingValidator;
import com.pingidentity.admin.api.validator.FragmentPolicyOutputContractValidator;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class ApcMappingActionValidator
extends AbstractActionValidator {
    private final C2cContractManager apcMgr;
    private final ValidatorContext context;

    public ApcMappingActionValidator(ActionValidatorInfo info, C2cContractManager apcMgr, ValidatorContext context) {
        super(info);
        this.apcMgr = apcMgr;
        this.context = context;
        if (info != null && info.getFragmentInfo() != null) {
            String apcId = Optional.ofNullable((ApcMappingPolicyAction)info.getAction()).map(ApcMappingPolicyAction::getAuthenticationPolicyContractRef).map(ResourceLink::getId).orElse(null);
            this.addValidator((Validator)new FragmentPolicyOutputContractValidator(this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationPolicyContractRefId()), CollectionUtils.isEmpty(this.validatorInfo.getChildren()), this.validatorInfo.getFragmentInfo(), apcId));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (((ApcMappingPolicyAction)this.validatorInfo.getAction()).getAuthenticationPolicyContractRef() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_incomplete_missing_authn_policy_contract_ref, this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationPolicyContractRef())));
        } else {
            String apcId = ((ApcMappingPolicyAction)this.validatorInfo.getAction()).getAuthenticationPolicyContractRef().getId();
            if (apcId == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.apc_id_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationPolicyContractRefId())));
            } else {
                C2cContract apc = this.getAndValidateApc(apcId);
                if (apc != null && !this.hasErrors()) {
                    AbstractAuthnPolicyAttributeMappingValidator attributeMappingValidator = this.validatorInfo.isFragmentPolicy() && this.validatorInfo.getFragmentInfo().getInputContract() != null ? new FragmentApcAttributeMappingValidator(((ApcMappingPolicyAction)this.validatorInfo.getAction()).getAttributeMapping(), apc, this.validatorInfo.getUpstreamSources(), this.validatorInfo.getRootFieldPath(), this.validatorInfo.getTrackedParams(), this.context, this.validatorInfo.getFragmentInfo().getInputContract().getAllAttrNamesSorted()) : new AuthnPolicyApcAttributeMappingValidator(((ApcMappingPolicyAction)this.validatorInfo.getAction()).getAttributeMapping(), apc, this.validatorInfo.getUpstreamSources(), this.validatorInfo.getRootFieldPath(), this.validatorInfo.getTrackedParams(), this.context);
                    attributeMappingValidator.validate();
                    this.appendErrors(attributeMappingValidator.getErrors());
                }
            }
        }
        return !this.hasErrors();
    }

    private C2cContract getAndValidateApc(String apcId) {
        C2cContract apc = this.apcMgr.getContract(apcId);
        if (apc == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.apc_id_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationPolicyContractRefId())));
        }
        return apc;
    }

    @Override
    protected boolean isActionAllowed() {
        if (this.validatorInfo.getParentNodeAction() == null) {
            return false;
        }
        if (this.validatorInfo.isFragmentPolicy()) {
            return true;
        }
        return this.validatorInfo.hasAuthnSourceAncestor() && this.validatorInfo.hasSuccessInPath();
    }

    @Override
    protected boolean needsChildren() {
        return false;
    }
}

