/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.AccessTokenManagerPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AtmAccessControlSetingsValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private boolean inherited;
    private boolean restrictClients;
    private List<String> allowedClients;
    private ValidatorContext validatorContext;

    public AtmAccessControlSetingsValidator(boolean inherited, boolean restrictClients, List<String> allowedClients, ValidatorContext validatorContext) {
        this.inherited = inherited;
        this.restrictClients = restrictClients;
        this.allowedClients = allowedClients;
        this.validatorContext = validatorContext;
    }

    public boolean validate() {
        Collection validClients;
        if (this.restrictClients && (this.allowedClients == null || this.allowedClients.isEmpty())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_access_token_management_restrict_allowed_clients_with_empty_clients_list, AccessTokenManagerPaths.getAccessControlSettings()));
        }
        if (!this.inherited && this.restrictClients && this.allowedClients != null && !this.validatorContext.isBulkConfigRequest() && (validClients = MgmtFactory.getClientManager().getValidClients(this.allowedClients)).size() != this.allowedClients.size()) {
            int index = -1;
            for (String clientId : this.allowedClients) {
                ++index;
                if (validClients.contains(clientId)) continue;
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_access_token_management_invalid_client_id, AccessTokenManagerPaths.getAllowedClientId(index), new Object[]{clientId}));
            }
        }
        return !this.hasErrors();
    }
}

