/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.Map;
import java.util.Set;

public class AttributeFulfillmentValueValidator
extends AbstractValidator {
    private final Set<SourceType> validSourceTypes;
    private final Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources;
    private final ValidatorContext context;
    private final String fulfillmentPath;
    private final String attrName;
    private final AttributeFulfillmentValue attrValue;

    public AttributeFulfillmentValueValidator(Set<SourceType> validSourceTypes, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, ValidatorContext context, String fulfillmentPath, String attrName, AttributeFulfillmentValue attrValue) {
        this.validSources = validSources;
        this.validSourceTypes = validSourceTypes;
        this.context = context;
        this.fulfillmentPath = fulfillmentPath;
        this.attrName = attrName;
        this.attrValue = attrValue;
    }

    public boolean validate() {
        this.validateAttributeFulfillmentValue();
        return this.hasErrors();
    }

    private void validateAttributeFulfillmentValue() {
        if (this.attrValue == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_missing_attribute_fulfillment_value, ConnectionPaths.getAttributeMappingPath(this.fulfillmentPath, this.attrName), new Object[]{this.attrName}));
        } else {
            String value = this.attrValue.getValue();
            SourceTypeIdKey sourceKey = this.attrValue.getSource();
            ValidationError sourceTypeError = AttributeMappingValidator.validateSourceTypeIdKey(sourceKey, this.validSources, this.validSourceTypes, ConnectionPaths.getAttributeMappingPath(this.fulfillmentPath, this.attrName), AttributeMappingValidator.SourceKeyMsgContext.ATTR_MAPPING, this.attrName, this.context);
            if (sourceTypeError != null) {
                this.appendError(sourceTypeError);
            }
            if (value == null && sourceKey != null && !SourceType.NO_MAPPING.equals((Object)sourceKey.getType())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_value_value_required, ConnectionPaths.getAttributeMappingValuePath(this.fulfillmentPath, this.attrName), new Object[]{this.attrName}));
            }
            if (value != null && this.validSources.get(sourceKey) != null) {
                this.validateSourceAndValue();
            }
        }
    }

    private void validateSourceAndValue() {
        String attributePath = ConnectionPaths.getAttributeMappingPath(this.fulfillmentPath, this.attrName);
        SourceTypeValidatorBuilder builder = this.validSources.get(this.attrValue.getSource());
        Validator validator = builder.buildMappingValidator(this.attrName, this.attrValue, attributePath);
        if (!validator.validate()) {
            this.appendErrors(validator.getErrors());
        }
    }
}

