/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.ExpressionIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.LdapAttributeSource;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeFulfillmentValueValidator;
import com.pingidentity.admin.api.validator.AttributeSourceValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ListEmptyValidator;
import com.pingidentity.admin.api.validator.MappedAttributesSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.OgnlExpressionValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AttributeMappingValidator
extends CompositeValidator {
    private final AttributeMapping attrMapping;
    private final Set<String> validAttributeNames;
    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources;
    private final Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSourcesDefault;
    private final Map<String, Map<SourceTypeIdKey, SourceTypeValidatorBuilder>> validSourcesForAttributeSources;
    private final Set<SourceType> validSourceTypes = new HashSet<SourceType>();
    private final Map<String, Set<SourceType>> validSourceTypesByAttributeSourceId = new HashMap<String, Set<SourceType>>();
    protected final String attrMappingPath;
    private final Set<String> substitutionVars = new HashSet<String>();
    private boolean isExpressProvisioning;
    private boolean skipValidateVars;
    private boolean skipValidateMissingAttrInMapping = false;
    private final ValidatorContext context;

    private AttributeMappingValidator(AttributeMapping mapping, Set<String> validAttributeNames, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, Map<String, Map<SourceTypeIdKey, SourceTypeValidatorBuilder>> validSourcesForAttributeSources, String attrMappingPath, ValidatorContext context) {
        this.attrMapping = mapping;
        this.validAttributeNames = validAttributeNames;
        this.validSourcesDefault = validSources;
        this.validSources = validSources;
        this.validSourcesForAttributeSources = validSourcesForAttributeSources;
        this.attrMappingPath = attrMappingPath;
        this.context = context;
    }

    public AttributeMappingValidator(AttributeMapping mapping, Set<String> validAttributeNames, Set<String> coreSourceSubstitutionVars, String coreSourceName, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, Map<String, Map<SourceTypeIdKey, SourceTypeValidatorBuilder>> validSourcesForAttributeSources, String baseMappingPath, ValidatorContext context) {
        this(mapping, validAttributeNames, validSources, validSourcesForAttributeSources, baseMappingPath, context);
        this.initialize(mapping, coreSourceSubstitutionVars, coreSourceName);
    }

    public AttributeMappingValidator(AttributeMapping mapping, Set<String> validAttributeNames, Set<String> coreSourceSubstitutionVars, String coreSourceName, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, String baseMappingPath, ValidatorContext context) {
        this(mapping, validAttributeNames, validSources, null, baseMappingPath, context);
        this.initialize(mapping, coreSourceSubstitutionVars, coreSourceName);
    }

    public AttributeMappingValidator(AttributeMapping mapping, Set<String> validAttributeNames, Set<String> coreSourceSubstitutionVars, String coreSourceName, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, boolean skipValidateMissingAttrInMapping, String baseMappingPath, ValidatorContext context) {
        this(mapping, validAttributeNames, validSources, null, baseMappingPath, context);
        this.skipValidateMissingAttrInMapping = skipValidateMissingAttrInMapping;
        this.initialize(mapping, coreSourceSubstitutionVars, coreSourceName);
    }

    public AttributeMappingValidator(AttributeMapping mapping, Set<String> validAttributeNames, Set<String> coreSourceSubstitutionVars, String coreSourceName, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, String baseMappingPath, boolean validateLdapVars, ValidatorContext context) {
        this(mapping, validAttributeNames, validSources, null, baseMappingPath, context);
        this.skipValidateVars = validateLdapVars;
        this.initialize(mapping, coreSourceSubstitutionVars, coreSourceName);
    }

    private void initialize(AttributeMapping mapping, Set<String> coreSourceSubstitutionVars, String coreSourceName) {
        boolean sourceContainsFulfillment;
        int i = 0;
        HashSet<String> aggregateListWithCoreAndPreviousAttrSourceValues = new HashSet<String>();
        if (coreSourceSubstitutionVars != null) {
            aggregateListWithCoreAndPreviousAttrSourceValues.addAll(coreSourceSubstitutionVars);
        }
        if (sourceContainsFulfillment = this.isSourceContainsFulfillment(mapping.getAttributeSources())) {
            this.addValidator((Validator)new ListEmptyValidator(mapping.getIssuanceCriteria().getConditionalCriteria(), ApiMessageKey.issuance_criteria_not_applicable, ConnectionPaths.getIssuanceCriteriaPath(this.attrMappingPath)));
            this.addValidator((Validator)new ListEmptyValidator(mapping.getIssuanceCriteria().getExpressionCriteria(), ApiMessageKey.issuance_criteria_not_applicable, ConnectionPaths.getIssuanceCriteriaPath(this.attrMappingPath)));
        }
        for (AttributeSource attributeSource : mapping.getAttributeSources()) {
            if (attributeSource == null) {
                ++i;
                continue;
            }
            AttributeSourceValidator validator = new AttributeSourceValidator(attributeSource, this.isExpressProvisioning, ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, i), this.context);
            validator.setSkipValidateVars(this.skipValidateVars);
            HashSet<String> freshListWithCoreAndPreviousAttrSourceValues = new HashSet<String>();
            if (aggregateListWithCoreAndPreviousAttrSourceValues != null) {
                freshListWithCoreAndPreviousAttrSourceValues.addAll(aggregateListWithCoreAndPreviousAttrSourceValues);
            }
            validator.setCoreSourceSubstitutionVars(coreSourceName, freshListWithCoreAndPreviousAttrSourceValues);
            this.addToListWithCoreAndPreviousAttrSourceValues(attributeSource, aggregateListWithCoreAndPreviousAttrSourceValues, this.validSources);
            this.addValidator((Validator)validator);
            if (this.doValidateAttrSourceId(mapping)) {
                this.addValidator((Validator)new NotBlankValidator(attributeSource.getId(), "ID", ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, i)));
            }
            ++i;
        }
        for (Map.Entry entry : this.validSources.entrySet()) {
            Set<String> exposedVars;
            SourceTypeValidatorBuilder sourceTypeBuilder = (SourceTypeValidatorBuilder)entry.getValue();
            if (sourceTypeBuilder != null && (exposedVars = sourceTypeBuilder.getExposedSubstitutionVariables()) != null) {
                this.substitutionVars.addAll(exposedVars);
            }
            this.validSourceTypes.add(((SourceTypeIdKey)entry.getKey()).getType());
        }
        if (this.validSourcesForAttributeSources != null) {
            for (Map.Entry entry : this.validSourcesForAttributeSources.entrySet()) {
                HashSet<SourceType> types = new HashSet<SourceType>();
                for (Map.Entry sourceEntry : ((Map)entry.getValue()).entrySet()) {
                    Set<String> exposedVars;
                    SourceTypeValidatorBuilder sourceTypeBuilder = (SourceTypeValidatorBuilder)sourceEntry.getValue();
                    if (sourceTypeBuilder != null && (exposedVars = sourceTypeBuilder.getExposedSubstitutionVariables()) != null) {
                        this.substitutionVars.addAll(exposedVars);
                    }
                    types.add(((SourceTypeIdKey)sourceEntry.getKey()).getType());
                }
                this.validSourceTypesByAttributeSourceId.put((String)entry.getKey(), types);
            }
        }
        AttributeMappingValidator.populateSourceTypeBuilderSubstitutionValue(this.substitutionVars, this.validSources);
    }

    static void populateSourceTypeBuilderSubstitutionValue(Set<String> substitutionVars, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        if (!substitutionVars.isEmpty()) {
            for (SourceTypeValidatorBuilder builder : validSources.values()) {
                if (builder == null || !builder.acceptsSubstitutionVariables()) continue;
                builder.setSubstitutionVariables(substitutionVars);
            }
        }
    }

    public boolean doValidateAttrSourceId(AttributeMapping mapping) {
        boolean multipleAttributeSources = mapping.getAttributeSources().size() > 1;
        boolean sourceContainsFulfillment = this.isSourceContainsFulfillment(mapping.getAttributeSources());
        return multipleAttributeSources && !sourceContainsFulfillment;
    }

    private boolean isSourceContainsFulfillment(List<AttributeSource> sources) {
        for (AttributeSource source : sources) {
            if (source == null) {
                return false;
            }
            if (source.getAttributeContractFulfillment() == null || source.getAttributeContractFulfillment().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void addToListWithCoreAndPreviousAttrSourceValues(AttributeSource attributeSource, Set<String> listWithPreviousRenameMe, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        for (Map.Entry<SourceTypeIdKey, SourceTypeValidatorBuilder> sourceEntry : validSources.entrySet()) {
            Set<String> exposedVars;
            SourceTypeValidatorBuilder sourceTypeBuilder;
            if (attributeSource.getId() == null || !attributeSource.getId().equals(sourceEntry.getKey().getId()) || (sourceTypeBuilder = sourceEntry.getValue()) == null || (exposedVars = sourceTypeBuilder.getExposedSubstitutionVariables()) == null) continue;
            listWithPreviousRenameMe.addAll(exposedVars);
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateAttributeSourceListNullEntries();
        this.validateConditionalCriteriaListNullEntries();
        this.validateExpressionIssuanceCriteriaListNullEntries();
        if (!this.hasErrors()) {
            this.validateMappings();
            this.validateIssuanceCriteria();
        }
        if (!this.hasErrors()) {
            this.validateMemberOfAttributeNestedGroup();
        }
        return !this.hasErrors();
    }

    private void validateExpressionIssuanceCriteriaListNullEntries() {
        if (CollectionUtils.isNotEmpty(this.attrMapping.getIssuanceCriteria().getExpressionCriteria())) {
            int i = 0;
            for (ExpressionIssuanceCriteriaEntry expressionIssuanceCriteriaEntry : this.attrMapping.getIssuanceCriteria().getExpressionCriteria()) {
                if (AttributeMappingValidator.validateExpressionUpdates(this.context)) {
                    if (expressionIssuanceCriteriaEntry == null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, ConnectionPaths.getExpressionIssuanceCriteriaPath(this.attrMappingPath, i)));
                    }
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.expression_admin_role_required, ConnectionPaths.getExpressionIssuanceCriteriaPath(this.attrMappingPath, i)));
                }
                ++i;
            }
        }
    }

    private void validateConditionalCriteriaListNullEntries() {
        if (CollectionUtils.isNotEmpty(this.attrMapping.getIssuanceCriteria().getConditionalCriteria())) {
            int j = 0;
            for (ConditionalIssuanceCriteriaEntry conditionalIssuanceCriteriaEntry : this.attrMapping.getIssuanceCriteria().getConditionalCriteria()) {
                if (conditionalIssuanceCriteriaEntry == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, ConnectionPaths.getConditionalIssuanceCriteriaPath(this.attrMappingPath, j)));
                }
                ++j;
            }
        }
    }

    private void validateAttributeSourceListNullEntries() {
        if (CollectionUtils.isNotEmpty(this.attrMapping.getAttributeSources())) {
            int i = 0;
            for (AttributeSource attributeSource : this.attrMapping.getAttributeSources()) {
                if (attributeSource == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, i)));
                }
                ++i;
            }
        }
    }

    protected void validateMemberOfAttributeNestedGroup() {
        String path;
        Object basePath;
        HashMap<String, Integer> sourceIdsWithNestedGroup = new HashMap<String, Integer>();
        int index = 0;
        for (AttributeSource source : this.attrMapping.getAttributeSources()) {
            LdapAttributeSource ldapSource;
            if (source.getType() == DataStoreType.LDAP && (ldapSource = (LdapAttributeSource)source).isMemberOfNestedGroup()) {
                boolean bl = MgmtFactory.getDataSourceManager().getLdapDataSource(source.getDataStoreRef().getId()).isActiveDirectoryType();
                if (bl) {
                    sourceIdsWithNestedGroup.put(source.getId(), index);
                } else {
                    basePath = ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, index);
                    path = ConnectionPaths.getAttributeSourceLdapDSMemberOfNestedGroup((String)basePath);
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_source_memberof_nested_group_ad_only, path));
                }
            }
            ++index;
        }
        if (!this.hasErrors() && !sourceIdsWithNestedGroup.isEmpty()) {
            HashSet<String> sourceIdsWithMemberOf = new HashSet<String>();
            String expressionMemberOf = "#this.get(\"ds.%s.memberOf\")";
            for (AttributeFulfillmentValue attributeFulfillmentValue : this.attrMapping.getAttributeContractFulfillment().values()) {
                if (attributeFulfillmentValue.getSource().getType() == SourceType.LDAP_DATA_STORE && "memberOf".equals(attributeFulfillmentValue.getValue())) {
                    sourceIdsWithMemberOf.add(attributeFulfillmentValue.getSource().getId());
                }
                for (String key : sourceIdsWithNestedGroup.keySet()) {
                    if (attributeFulfillmentValue.getSource().getType() != SourceType.EXPRESSION || attributeFulfillmentValue.getValue().indexOf(String.format(expressionMemberOf, key)) == -1) continue;
                    sourceIdsWithMemberOf.add(key);
                }
            }
            for (ConditionalIssuanceCriteriaEntry conditionalIssuanceCriteriaEntry : this.attrMapping.getIssuanceCriteria().getConditionalCriteria()) {
                if (conditionalIssuanceCriteriaEntry.getSource().getType() != SourceType.LDAP_DATA_STORE || !"memberOf".equals(conditionalIssuanceCriteriaEntry.getAttributeName())) continue;
                sourceIdsWithMemberOf.add(conditionalIssuanceCriteriaEntry.getSource().getId());
            }
            if (this.attrMapping.getIssuanceCriteria().getExpressionCriteria() != null) {
                for (ExpressionIssuanceCriteriaEntry expressionIssuanceCriteriaEntry : this.attrMapping.getIssuanceCriteria().getExpressionCriteria()) {
                    for (String key : sourceIdsWithNestedGroup.keySet()) {
                        if (expressionIssuanceCriteriaEntry.getExpression().indexOf(String.format(expressionMemberOf, key)) == -1) continue;
                        sourceIdsWithMemberOf.add(key);
                    }
                }
            }
            for (Map.Entry entry : sourceIdsWithNestedGroup.entrySet()) {
                if (sourceIdsWithMemberOf.contains(entry.getKey())) continue;
                basePath = ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, (Integer)entry.getValue());
                path = ConnectionPaths.getAttributeSourceLdapDSMemberOfNestedGroup((String)basePath);
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_source_memberof_nested_group, path, new Object[]{"memberOf"}));
            }
        }
    }

    private void validateMappings() {
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> descs = new ArrayList<String>();
        int i = 0;
        for (AttributeSource source : this.attrMapping.getAttributeSources()) {
            if (ids.contains(source.getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_duplicate_id, ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, i), new Object[]{source.getId()}));
            }
            if (descs.contains(source.getDescription())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_duplicate_description, ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, i), new Object[]{source.getDescription()}));
            }
            if (source.getId() != null) {
                ids.add(source.getId());
            }
            if (source.getDescription() != null) {
                descs.add(source.getDescription());
            }
            if (source.getAttributeContractFulfillment() != null && !source.getAttributeContractFulfillment().isEmpty() && this.validSourcesForAttributeSources == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_attribute_fulfillment_not_applicable, ConnectionPaths.getAttributeSourcePath(this.attrMappingPath, i)));
            }
            ++i;
        }
        if (this.validAttributeNames != null) {
            for (AttributeSource s : this.attrMapping.getAttributeSources()) {
                if (s.getAttributeContractFulfillment() == null || this.validSourcesForAttributeSources == null) continue;
                this.validSources = this.validSourcesForAttributeSources.get(s.getDataStoreRef().getId());
                this.validateFulfillment(s.getAttributeContractFulfillment(), this.validSourceTypesByAttributeSourceId.get(s.getDataStoreRef().getId()), this.validSources);
            }
            if (!this.isAbortSso(this.attrMapping)) {
                this.validSources = this.validSourcesDefault;
                this.validateFulfillment(this.attrMapping.getAttributeContractFulfillment(), this.validSourceTypes, this.validSources);
            }
        }
    }

    protected void validateFulfillment(Map<String, AttributeFulfillmentValue> attrFulfillment, Set<SourceType> validSourceTypes, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        HashSet<String> validAttrs = new HashSet<String>();
        String fulfillmentPath = ConnectionPaths.getAttributeMappingContractFulfillmentPath(this.attrMappingPath);
        for (String attrName : attrFulfillment.keySet()) {
            if (this.validAttributeNames.contains(attrName)) {
                validAttrs.add(attrName);
                continue;
            }
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_no_such_attribute, ConnectionPaths.getAttributeMappingPath(fulfillmentPath, attrName), new Object[]{attrName}));
        }
        if (!this.skipValidateMissingAttrInMapping) {
            for (String attrName : this.validAttributeNames) {
                if (attrName == null || validAttrs.contains(attrName)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_missing_attribute, ConnectionPaths.getAttributeMappingPath(fulfillmentPath, attrName), new Object[]{attrName}));
            }
        }
        AttributeMappingValidator.populateSourceTypeBuilderSubstitutionValue(this.substitutionVars, validSources);
        for (String attrName : validAttrs) {
            AttributeFulfillmentValue attrValue = attrFulfillment.get(attrName);
            AttributeFulfillmentValueValidator attributeFulfillmentValueValidator = new AttributeFulfillmentValueValidator(validSourceTypes, validSources, this.context, fulfillmentPath, attrName, attrValue);
            attributeFulfillmentValueValidator.validate();
            if (!attributeFulfillmentValueValidator.hasErrors()) continue;
            this.appendErrors(attributeFulfillmentValueValidator.getErrors());
        }
    }

    public boolean isAbortSso(AttributeMapping attrMapping) {
        for (AttributeSource source : attrMapping.getAttributeSources()) {
            if (source.getAttributeContractFulfillment() == null || attrMapping.getAttributeContractFulfillment() != null && !attrMapping.getAttributeContractFulfillment().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void validateIssuanceCriteria() {
        List<ExpressionIssuanceCriteriaEntry> expressionCriteria;
        if (!this.attrMapping.getIssuanceCriteria().getConditionalCriteria().isEmpty()) {
            HashSet<Object> conditionalEntryHashes = new HashSet<Object>();
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validICSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>(this.validSources);
            HashSet<SourceType> validICSourceTypes = new HashSet<SourceType>(this.validSourceTypes);
            Iterator it = validICSources.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry sourceTypeEntry = it.next();
                SourceType tempSourceType = ((SourceTypeIdKey)sourceTypeEntry.getKey()).getType();
                if (tempSourceType != SourceType.TEXT && tempSourceType != SourceType.EXPRESSION) continue;
                it.remove();
            }
            validICSourceTypes.remove((Object)SourceType.TEXT);
            validICSourceTypes.remove((Object)SourceType.EXPRESSION);
            MappedAttributesSourceTypeValidatorBuilder maBuilder = new MappedAttributesSourceTypeValidatorBuilder();
            if (this.validAttributeNames != null) {
                maBuilder.setMappedAttributes(this.validAttributeNames);
            }
            validICSources.put(new SourceTypeIdKey(SourceType.MAPPED_ATTRIBUTES), maBuilder);
            validICSourceTypes.add(SourceType.MAPPED_ATTRIBUTES);
            int i = 0;
            for (ConditionalIssuanceCriteriaEntry icEntry : this.attrMapping.getIssuanceCriteria().getConditionalCriteria()) {
                String icEntryPath = ConnectionPaths.getConditionalIssuanceCriteriaPath(this.attrMappingPath, i);
                Integer critHashCode = icEntry.criteriaHashCode();
                if (conditionalEntryHashes.contains(critHashCode)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.issuance_criteria_duplicate_entry, icEntryPath));
                } else {
                    SourceTypeValidatorBuilder icBuilder;
                    Validator validator;
                    conditionalEntryHashes.add(critHashCode);
                    ValidationError sourceTypeError = AttributeMappingValidator.validateSourceTypeIdKey(icEntry.getSource(), validICSources, validICSourceTypes, icEntryPath, SourceKeyMsgContext.ISSUANCE_CRITERIA, null, this.context);
                    if (sourceTypeError != null) {
                        this.appendError(sourceTypeError);
                    }
                    if (validICSources.get(icEntry.getSource()) != null && !(validator = (icBuilder = (SourceTypeValidatorBuilder)validICSources.get(icEntry.getSource())).buildConditionalIssuanceCriteriaValidator(icEntry, icEntryPath)).validate()) {
                        this.appendErrors(validator.getErrors());
                    }
                }
                ++i;
            }
        }
        if ((expressionCriteria = this.attrMapping.getIssuanceCriteria().getExpressionCriteria()) != null) {
            if (ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
                MappedAttributesSourceTypeValidatorBuilder maBuilder = new MappedAttributesSourceTypeValidatorBuilder();
                if (this.validAttributeNames != null) {
                    maBuilder.setMappedAttributes(this.validAttributeNames);
                }
                HashSet<Integer> expressionEntryHashes = new HashSet<Integer>();
                int i = 0;
                for (ExpressionIssuanceCriteriaEntry icEntry : expressionCriteria) {
                    String icEntryPath = ConnectionPaths.getExpressionIssuanceCriteriaPath(this.attrMappingPath, i);
                    Integer critHashCode = icEntry.criteriaHashCode();
                    if (expressionEntryHashes.contains(critHashCode)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.issuance_criteria_duplicate_entry, icEntryPath));
                    } else {
                        expressionEntryHashes.add(critHashCode);
                        if (StringUtils.isBlank((String)icEntry.getExpression())) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.issuance_criteria_expression_required, ConnectionPaths.getExpressionIssuanceCriteriaExprPath(icEntryPath)));
                        } else {
                            HashMap<String, String> substitutionValues = new HashMap<String, String>();
                            for (String substitutionVar : this.substitutionVars) {
                                substitutionValues.put(substitutionVar, substitutionVar);
                            }
                            for (String exposedVar : maBuilder.getExposedSubstitutionVariables()) {
                                substitutionValues.put(exposedVar, exposedVar);
                            }
                            OgnlExpressionValidator ognlExpressionValidator = new OgnlExpressionValidator(icEntry.getExpression(), icEntryPath, true, substitutionValues, this.context != null && this.context.isBypassExternalValidation());
                            ognlExpressionValidator.validate();
                            this.appendErrors(ognlExpressionValidator.getErrors());
                        }
                    }
                    ++i;
                }
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.issuance_criteria_expression_not_enabled, ConnectionPaths.getExpressionIssuanceCriteriaPath(this.attrMappingPath)));
            }
        }
    }

    static ValidationError validateSourceTypeIdKey(SourceTypeIdKey sourceKey, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, Set<SourceType> validSourceTypes, String basePath, SourceKeyMsgContext msgContext, String attrName, ValidatorContext context) {
        ValidationError error = null;
        if (sourceKey == null) {
            error = ValidationErrorFactory.getInstance().create(msgContext.getRequiredKey(), ConnectionPaths.getSourcePath(basePath), new Object[]{attrName});
        } else {
            SourceType sourceType = sourceKey.getType();
            String sourceId = sourceKey.getId();
            boolean sourceTypeValid = validSourceTypes.contains((Object)sourceType);
            if (sourceType == null) {
                error = ValidationErrorFactory.getInstance().create(msgContext.getTypeRequiredKey(), ConnectionPaths.getSourceTypePath(basePath), new Object[]{attrName});
            } else if (!sourceTypeValid) {
                error = ValidationErrorFactory.getInstance().create(msgContext.getTypeNotApplicableKey(), ConnectionPaths.getSourceTypePath(basePath), new Object[]{sourceType, attrName});
            } else if (SourceType.EXPRESSION == sourceType) {
                if (!AttributeMappingValidator.validateExpressionUpdates(context)) {
                    error = ValidationErrorFactory.getInstance().create(ApiMessageKey.expression_admin_role_required, ConnectionPaths.getSourceTypePath(basePath));
                }
            } else if (validSources.get(new SourceTypeIdKey(sourceType, sourceId)) == null) {
                error = sourceId != null ? ValidationErrorFactory.getInstance().create(msgContext.getSourceWithIdNotFoundKey(), ConnectionPaths.getSourcePath(basePath), new Object[]{sourceType, sourceId, attrName}) : ValidationErrorFactory.getInstance().create(msgContext.getSourceNotFoundKey(), ConnectionPaths.getSourcePath(basePath), new Object[]{sourceType, attrName});
            }
        }
        return error;
    }

    static boolean validateExpressionUpdates(ValidatorContext context) {
        boolean isExpressionAdmin = true;
        if (!context.isAllowExpressionUpdates()) {
            isExpressionAdmin = false;
        }
        return isExpressionAdmin;
    }

    public void setExpressProvisioning(boolean isExpressProvisioning) {
        this.isExpressProvisioning = isExpressProvisioning;
    }

    public static enum SourceKeyMsgContext {
        ATTR_MAPPING{

            @Override
            public ApiMessageKey getRequiredKey() {
                return ApiMessageKey.attribute_mapping_value_source_required;
            }

            @Override
            public ApiMessageKey getTypeRequiredKey() {
                return ApiMessageKey.attribute_mapping_value_source_type_required;
            }

            @Override
            public ApiMessageKey getTypeNotApplicableKey() {
                return ApiMessageKey.attribute_mapping_value_source_type_not_applicable;
            }

            @Override
            public ApiMessageKey getSourceWithIdNotFoundKey() {
                return ApiMessageKey.attribute_mapping_value_source_id_not_found;
            }

            @Override
            public ApiMessageKey getSourceNotFoundKey() {
                return ApiMessageKey.attribute_mapping_value_source_not_found;
            }
        }
        ,
        ISSUANCE_CRITERIA{

            @Override
            public ApiMessageKey getRequiredKey() {
                return ApiMessageKey.issuance_criteria_source_required;
            }

            @Override
            public ApiMessageKey getTypeRequiredKey() {
                return ApiMessageKey.issuance_criteria_source_type_required;
            }

            @Override
            public ApiMessageKey getTypeNotApplicableKey() {
                return ApiMessageKey.issuance_criteria_source_type_not_applicable;
            }

            @Override
            public ApiMessageKey getSourceWithIdNotFoundKey() {
                return ApiMessageKey.issuance_criteria_source_id_not_found;
            }

            @Override
            public ApiMessageKey getSourceNotFoundKey() {
                return ApiMessageKey.issuance_criteria_source_not_found;
            }
        };


        public abstract ApiMessageKey getRequiredKey();

        public abstract ApiMessageKey getTypeRequiredKey();

        public abstract ApiMessageKey getTypeNotApplicableKey();

        public abstract ApiMessageKey getSourceWithIdNotFoundKey();

        public abstract ApiMessageKey getSourceNotFoundKey();
    }
}

