/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;

public class AttributeSetSourceTypeValidator
extends AbstractValidator {
    private final String attributeName;
    private final String value;
    private final String fieldPath;
    private final Set<String> attributes;
    private final AttributeSetTypeMsgContext msgContext;
    private final String msgSourceType;

    AttributeSetSourceTypeValidator(String attributeName, String value, Set<String> attributes, String fieldPath, AttributeSetTypeMsgContext msgContext, String msgSourceType) {
        this.attributeName = attributeName;
        this.value = value;
        this.attributes = attributes;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
        this.msgSourceType = msgSourceType;
    }

    public boolean validate() {
        if (!this.attributes.contains(this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getInvalidAttributeKey(), this.fieldPath, new Object[]{this.value, this.attributeName, this.msgSourceType, this.msgSourceType}));
            return false;
        }
        return true;
    }

    public static enum AttributeSetTypeMsgContext {
        ATTR_MAPPING{

            @Override
            public ApiMessageKey getInvalidAttributeKey() {
                return ApiMessageKey.mapping_source_type_invalid_attribute;
            }
        }
        ,
        ISSUANCE_CRITERIA{

            @Override
            public ApiMessageKey getInvalidAttributeKey() {
                return ApiMessageKey.issuance_criteria_source_type_invalid_attribute;
            }
        };


        public abstract ApiMessageKey getInvalidAttributeKey();
    }
}

