/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidator;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AttributeSetSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private final Set<String> attributes;
    private final SourceType sourceType;
    private String substitutionVarPrefix;

    public AttributeSetSourceTypeValidatorBuilder(Set<String> attributes, SourceType sourceType) {
        if (attributes == null || sourceType == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.attributes = attributes;
        this.sourceType = sourceType;
    }

    AttributeSetSourceTypeValidatorBuilder(Set<String> attributes, SourceType sourceType, String substitutionVarPrefix) {
        if (attributes == null || sourceType == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.attributes = attributes;
        this.sourceType = sourceType;
        this.substitutionVarPrefix = substitutionVarPrefix;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), this.sourceType);
        return new AttributeSetSourceTypeValidator(attributeName, afv.getValue(), this.attributes, attributePath, AttributeSetSourceTypeValidator.AttributeSetTypeMsgContext.ATTR_MAPPING, this.getSourceTypeErrorMsgValue());
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), this.sourceType);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new AttributeSetSourceTypeValidator(icEntry.getAttributeName(), icEntry.getAttributeName(), this.attributes, attributePath, AttributeSetSourceTypeValidator.AttributeSetTypeMsgContext.ISSUANCE_CRITERIA, this.getSourceTypeErrorMsgValue()), icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        if (!StringUtils.isEmpty((String)this.substitutionVarPrefix)) {
            HashSet<String> result = new HashSet<String>();
            for (String attr : this.attributes) {
                result.add(this.substitutionVarPrefix + "." + attr);
            }
            return result;
        }
        return Collections.unmodifiableSet(this.attributes);
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }

    public Set<String> getAssertionAttributes() {
        return this.attributes;
    }

    private String getSourceTypeErrorMsgValue() {
        switch (this.sourceType) {
            case ADAPTER: {
                return "adapter";
            }
            case ASSERTION: {
                return "assertion";
            }
            case AUTHENTICATION_POLICY_CONTRACT: {
                return "authenticationPolicyContract";
            }
            case REQUEST: {
                return "request";
            }
        }
        return "";
    }
}

