/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.auditing.AuditLoggingSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.email.SmtpNotificationPlugin;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;

public class AuditLoggingSettingsValidator
extends AbstractValidator {
    private static final String EMAILS_PATH = "emailsToNotify";
    private static final String THRESHOLD_PATH = "threshold";
    private static final String INTERVAL_PATH = "interval";
    private static final String NOTIFICATION_PUBLISHER_PATH = "notificationPublisher";
    private final NotificationPublisherPluginManager notificationPublisherPluginManager;
    private final AuditLoggingSettings settings;
    private final ValidationErrorFactory validationErrorFactory;

    public AuditLoggingSettingsValidator(NotificationPublisherPluginManager notificationPublisherPluginManager, ValidationErrorFactory validationErrorFactory, AuditLoggingSettings settings) {
        this.notificationPublisherPluginManager = notificationPublisherPluginManager;
        this.settings = settings;
        this.validationErrorFactory = validationErrorFactory;
    }

    public AuditLoggingSettingsValidator(AuditLoggingSettings settings) {
        this(MgmtFactory.getNotificationPublisherPluginManager(), ValidationErrorFactory.getInstance(), settings);
    }

    private void validateNotificationPublisher(ResourceLink notificationPublisherRef, List<String> emailsToNotify) {
        String notificationPublisherId = notificationPublisherRef.getId();
        if (StringUtils.isBlank((String)notificationPublisherId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_id_missing, NOTIFICATION_PUBLISHER_PATH));
        } else {
            NotificationSenderPluginInstance instance = (NotificationSenderPluginInstance)this.notificationPublisherPluginManager.getInstance(notificationPublisherId);
            if (instance == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.notification_publisher_not_found, NOTIFICATION_PUBLISHER_PATH, new Object[]{notificationPublisherId}));
            } else if (SmtpNotificationPlugin.class.getCanonicalName().equals(instance.getDescriptor().getPluginClassName()) && (emailsToNotify == null || emailsToNotify.isEmpty())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.audit_logging_emails_required, EMAILS_PATH));
            }
        }
    }

    private void validateEmails(List<String> emailsToNotify) {
        ArrayList<String> emailsAlreadySeen = new ArrayList<String>();
        for (int index = 0; index < emailsToNotify.size(); ++index) {
            String email = emailsToNotify.get(index);
            EmailValidator emailValidator = EmailValidator.getInstance();
            if (!emailValidator.isValid(email)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.audit_logging_email_invalid, "emailsToNotify[" + index + "]", new Object[]{email}));
            }
            if (emailsAlreadySeen.contains(email)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.audit_logging_email_duplicate, "emailsToNotify[" + index + "]", new Object[]{email}));
            }
            emailsAlreadySeen.add(email);
        }
    }

    public boolean validate() {
        if (this.settings.getThreshold() != null && (this.settings.getThreshold() < 0 || this.settings.getThreshold() > 100)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.audit_logging_invalid_threshold, THRESHOLD_PATH));
        }
        if (this.settings.getInterval() != null && (this.settings.getInterval() < 0 || this.settings.getInterval() > 86400)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.audit_logging_invalid_interval, INTERVAL_PATH));
        }
        if (this.settings.getNotificationPublisher() != null) {
            this.validateNotificationPublisher(this.settings.getNotificationPublisher(), this.settings.getEmailsToNotify());
        }
        if (this.settings.getEmailsToNotify() != null) {
            this.validateEmails(this.settings.getEmailsToNotify());
        }
        return !this.hasErrors();
    }
}

