/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationApiApplicationPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.sp.UrlMatchingServiceMultipleStarImpl;

public class AuthenticationApiApplicationValidator
extends CompositeValidator {
    private boolean createMode;
    private String id;
    private String name;
    private List<String> allowedOrigins;
    private String url;
    private ResourceLink clientForRedirectlessModeRef;
    private boolean restrictAccessToRedirectless = false;

    public AuthenticationApiApplicationValidator(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public AuthenticationApiApplicationValidator(com.pingidentity.admin.api.model.AuthnApiApplication authnApiApplication, boolean createMode, boolean restrictAccessToRedirectless) {
        this.createMode = createMode;
        this.restrictAccessToRedirectless = restrictAccessToRedirectless;
        this.initialize(authnApiApplication);
        this.addValidator((Validator)new NotBlankValidator(this.name, "Name", AuthenticationApiApplicationPaths.getName()));
        this.addValidator((Validator)new NotBlankValidator(this.url, "URL", AuthenticationApiApplicationPaths.getUrl()));
        if (this.createMode) {
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 53, AuthenticationApiApplicationPaths.getAllowedId()));
        }
    }

    private void initialize(com.pingidentity.admin.api.model.AuthnApiApplication authnApiApplication) {
        this.id = authnApiApplication.getId();
        this.name = authnApiApplication.getName();
        this.allowedOrigins = authnApiApplication.getAdditionalAllowedOrigins();
        this.url = authnApiApplication.getUrl();
        this.clientForRedirectlessModeRef = authnApiApplication.getClientForRedirectlessModeRef();
    }

    @Override
    public boolean validate() {
        super.validate();
        Map<String, String> idNamesMap = MgmtFactory.getAuthnApiManager().getApiApplications().stream().collect(Collectors.toMap(AuthnApiApplication::getId, AuthnApiApplication::getName));
        if (this.createMode) {
            if (idNamesMap.values().contains(this.name)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_applications_duplicate_name, null, new Object[]{this.name}));
            }
            if (idNamesMap.keySet().contains(this.id)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_applications_duplicate_id, null, new Object[]{this.id}));
            }
        } else {
            for (Map.Entry<String, String> entry : idNamesMap.entrySet()) {
                if (!entry.getValue().equals(this.name) || entry.getKey().equals(this.id)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_applications_duplicate_name, null, new Object[]{this.name}));
            }
        }
        if (StringUtils.isNotBlank((String)this.url) && !ValidationUtil.isValidHttpsUrl((String)this.url)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_application_url_invalid, null, new Object[]{this.url}));
        }
        this.validateCrossOriginResourceSettings();
        this.validateClientIdForRedirectless();
        return !this.hasErrors();
    }

    public void validateCrossOriginResourceSettings() {
        if (!CollectionUtils.isEmpty(this.allowedOrigins)) {
            this.validateUniqueAllowedOrigins(this.allowedOrigins);
            UrlMatchingServiceMultipleStarImpl urlMatchingService = new UrlMatchingServiceMultipleStarImpl();
            for (String allowedOrigin : this.allowedOrigins) {
                if (urlMatchingService.isValidUrlPattern(allowedOrigin)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_application_cors_origin_invalid, AuthenticationApiApplicationPaths.getAllowedOrigins()));
            }
        }
    }

    private void validateUniqueAllowedOrigins(List<String> allowedOrigins) {
        UniqueEntriesValidator.UniqueKeyGetter<String> allowedOriginUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

            @Override
            public String getKey(String object) {
                return object;
            }
        };
        UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(allowedOriginUniqueKeyGetter, allowedOrigins, AuthenticationApiApplicationPaths.getAllowedOrigins(), ApiMessageKey.authentication_api_application_cors_origin_duplicate_entry);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }

    private void validateClientIdForRedirectless() {
        if (this.clientForRedirectlessModeRef == null) {
            return;
        }
        if (!this.restrictAccessToRedirectless) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_application_client_not_allowed, AuthenticationApiApplicationPaths.getClientForRedirectlessModeRef()));
        } else {
            Client client = MgmtFactory.getClientManager().getClient(this.clientForRedirectlessModeRef.getId());
            if (client == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_application_invalid_client_id, AuthenticationApiApplicationPaths.getClientIdForRedirectlessMode()));
            } else {
                if (!client.getAllowAuthenticationApiInit()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_application_client_cannot_use_redirectless_mode, AuthenticationApiApplicationPaths.getClientIdForRedirectlessMode(), new Object[]{client.getName()}));
                }
                ArrayList<String> validOrigins = new ArrayList<String>();
                if (!CollectionUtils.isEmpty(this.allowedOrigins)) {
                    for (String allowedOrigin : this.allowedOrigins) {
                        if (allowedOrigin.contains("*")) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_application_wildcard_origins_not_allowed_for_redirectless_mode, AuthenticationApiApplicationPaths.getAllowedOrigins(), new Object[]{allowedOrigin}));
                            continue;
                        }
                        validOrigins.add(allowedOrigin);
                    }
                }
                this.validateNoSharedOrigins(validOrigins);
            }
        }
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    private void validateNoSharedOrigins(List<String> validOrigins) {
        ArrayList<String> allOrigins = new ArrayList<String>(validOrigins);
        try {
            allOrigins.add(AuthnApiApplication.getOriginFromUrl((String)this.url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        for (AuthnApiApplication existingApp : MgmtFactory.getAuthnApiManager().getApiApplications()) {
            if (existingApp.getId().equals(this.id) || existingApp.getClientIdForRedirectlessMode() == null || existingApp.getClientIdForRedirectlessMode().equals(this.clientForRedirectlessModeRef.getId())) continue;
            List existingAppOrigins = existingApp.getAllAllowedOrigins();
            for (String origin : allOrigins) {
                for (String existingOrigin : existingAppOrigins) {
                    if (!origin.toLowerCase(Locale.ROOT).equals(existingOrigin.toLowerCase(Locale.ROOT))) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_api_application_origin_already_in_use_for_redirectless_mode, AuthenticationApiApplicationPaths.getAllowedOrigins(), new Object[]{origin, existingApp.getName()}));
                }
            }
        }
    }
}

