/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationPolicyContractMapping;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpIdentityMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.OnlyOneAttributeSourceValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TargetSessionMappingsValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationPolicyContractMappingsValidator
extends TargetSessionMappingsValidator {
    private C2cContractManager contractManager = MgmtFactory.getC2cContractManager();
    private Set<String> validApcIds = new HashSet<String>();

    public AuthenticationPolicyContractMappingsValidator(IdpBrowserSso browserSso, C2cContractManager c2cContractManager) {
        this(browserSso, Collections.emptyList(), c2cContractManager, null);
    }

    public AuthenticationPolicyContractMappingsValidator(IdpBrowserSso browserSso, List<String> availableVirtualServerIds, C2cContractManager c2cContractManager, ValidatorContext context) {
        super(browserSso, availableVirtualServerIds, context);
        this.contractManager = c2cContractManager;
        if (IdpIdentityMapping.NONE == browserSso.getIdpIdentityMapping()) {
            return;
        }
        List<AuthenticationPolicyContractMapping> apiApcMappings = browserSso.getAuthenticationPolicyContractMappings();
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        AttributeSetSourceTypeValidatorBuilder assertionSourceTypeBuilder = this.createAssertionValBuilder(browserSso);
        rootSources.put(new SourceTypeIdKey(SourceType.ACCOUNT_LINK), this.createAccountLinkValBuilder(browserSso));
        if (browserSso.getProtocol() == Protocol.OIDC) {
            rootSources.put(new SourceTypeIdKey(SourceType.CLAIMS), assertionSourceTypeBuilder);
        } else {
            rootSources.put(new SourceTypeIdKey(SourceType.ASSERTION), assertionSourceTypeBuilder);
        }
        rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyContractMapping> uniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyContractMapping>(){

            @Override
            public String getKey(AuthenticationPolicyContractMapping object) {
                if (object.getAuthenticationPolicyContractRef() != null && object.getAuthenticationPolicyContractRef().getId() != null) {
                    return object.getAuthenticationPolicyContractRef().getId();
                }
                return null;
            }
        };
        this.addValidator((Validator)new UniqueEntriesValidator<AuthenticationPolicyContractMapping>(uniqueKeyGetter, apiApcMappings, ConnectionPaths.getAuthenticationPolicyContractMappingsPath(), ApiMessageKey.authentication_policy_contract_mappings_duplicate_mappings));
        int apcIndex = 0;
        for (AuthenticationPolicyContractMapping apiApcMapping : apiApcMappings) {
            String contractId;
            String apcMappingPath = ConnectionPaths.getAuthenticationPolicyContractMappingsPath(apcIndex);
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            validSources.putAll(rootSources);
            validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE), this.createDsValBuilder(SourceType.LDAP_DATA_STORE, apiApcMapping));
            validSources.put(new SourceTypeIdKey(SourceType.JDBC_DATA_STORE), this.createDsValBuilder(SourceType.JDBC_DATA_STORE, apiApcMapping));
            validSources.put(new SourceTypeIdKey(SourceType.CUSTOM_DATA_STORE), this.createDsValBuilder(SourceType.CUSTOM_DATA_STORE, apiApcMapping));
            HashSet<String> apcContract = null;
            this.addValidator((Validator)new ResourceIdValidator(apiApcMapping.getAuthenticationPolicyContractRef(), "Authentication Policy Contract reference id", ConnectionPaths.getAuthenticationPolicyContractMappingApcLinkPath(apcIndex)));
            if (apiApcMapping.getAuthenticationPolicyContractRef() != null && apiApcMapping.getAuthenticationPolicyContractRef().getId() != null && this.validateApcExists(contractId = apiApcMapping.getAuthenticationPolicyContractRef().getId(), apcMappingPath)) {
                C2cContract c2cContract = this.contractManager.getContract(contractId);
                apcContract = new HashSet<String>();
                apcContract.addAll(c2cContract.getAllAttributeNames());
                this.validApcIds.add(contractId);
            }
            String fieldPath = ConnectionPaths.getAuthenticationPolicyContractMappingAttributeSourcePath(apcIndex);
            this.addValidator((Validator)new OnlyOneAttributeSourceValidator(apiApcMapping.getAttributeSources().size(), ApiMessageKey.authentication_policy_contract_mapping_multiple_attribute_sources, fieldPath));
            HashSet<String> sourceSubstitutionAttrs = new HashSet<String>();
            sourceSubstitutionAttrs.addAll(assertionSourceTypeBuilder.getAssertionAttributes());
            if (browserSso.getIdpIdentityMapping() == IdpIdentityMapping.ACCOUNT_LINKING) {
                sourceSubstitutionAttrs.add(IdpConnection.getLocalIdSubstitutionKey());
            }
            this.addValidator((Validator)new AttributeMappingValidator(apiApcMapping, apcContract, sourceSubstitutionAttrs, "assertion", validSources, apcMappingPath, this.getContext()));
            ++apcIndex;
        }
    }

    @Override
    public boolean validate() {
        if (IdpIdentityMapping.NONE == this.browserSso.getIdpIdentityMapping() && !this.browserSso.getAuthenticationPolicyContractMappings().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_not_required, ConnectionPaths.getAuthenticationPolicyContractMappingsPath()));
            return false;
        }
        super.validate();
        boolean noVsidErrorFound = false;
        int mappingIndex = 0;
        for (AuthenticationPolicyContractMapping authenticationPolicyContractMapping : this.browserSso.getAuthenticationPolicyContractMappings()) {
            int vsidIndex = 0;
            if (authenticationPolicyContractMapping.isRestrictVirtualServerIds() && this.availableVirtualServerIds.isEmpty() && !noVsidErrorFound) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_not_required, ConnectionPaths.getAuthenticationPolicyContractMappingRestrictedVirtualServerIdPath(mappingIndex)));
                noVsidErrorFound = true;
            } else if (!authenticationPolicyContractMapping.isRestrictVirtualServerIds() && !authenticationPolicyContractMapping.getRestrictedVirtualServerIds().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_ids_not_allowed, ConnectionPaths.getAuthenticationPolicyContractMappingRestrictedVirtualServerIdPath(mappingIndex)));
            } else {
                ArrayList<String> seenEntityIds = new ArrayList<String>(authenticationPolicyContractMapping.getRestrictedVirtualServerIds().size());
                for (String virtualEntityId : authenticationPolicyContractMapping.getRestrictedVirtualServerIds()) {
                    String virtualEntityPath = ConnectionPaths.getAuthenticationPolicyContractMappingRestrictedVirtualServerIdPath(mappingIndex, vsidIndex);
                    if (seenEntityIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_duplicate, virtualEntityPath, new Object[]{virtualEntityId}));
                    } else if (!this.availableVirtualServerIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_value_invalid_virtual_entity_id, virtualEntityPath, new Object[]{virtualEntityId}));
                    }
                    seenEntityIds.add(virtualEntityId);
                    ++vsidIndex;
                }
            }
            ++mappingIndex;
        }
        return !this.hasErrors();
    }

    private void validateApcId(String apcId, String fieldPath) {
        this.addValidator((Validator)new NotBlankValidator(apcId, "Authentication Policy Contract ID", ConnectionPaths.getResourceIdIdPath(fieldPath)));
    }

    private boolean validateApcExists(String apcId, String fieldPath) {
        C2cContract c2cContract = this.contractManager.getContract(apcId);
        if (c2cContract == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_not_found, ConnectionPaths.getResourceIdIdPath(fieldPath), new Object[]{apcId}));
        }
        return c2cContract != null;
    }

    public Set<String> getMappedApcIds() {
        return this.validApcIds;
    }
}

