/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationPolicyContractAttribute;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyContractPaths;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationPolicyContractValidator
extends CompositeValidator {
    private boolean isCreate;
    private String id;
    private String name;
    private List<AuthenticationPolicyContractAttribute> coreAttributes = new ArrayList<AuthenticationPolicyContractAttribute>();
    private List<AuthenticationPolicyContractAttribute> extendedAttributes = new ArrayList<AuthenticationPolicyContractAttribute>();
    private static final C2cContractManager C_2_C_CONTRACT_MANAGER = MgmtFactory.getC2cContractManager();

    public AuthenticationPolicyContractValidator(Builder builder) {
        this.isCreate = builder.isCreate;
        this.id = builder.apcId;
        this.name = builder.apcName;
        this.coreAttributes = builder.coreAttributes;
        this.extendedAttributes = builder.extendedAttributes;
        this.addValidator((Validator)new NotBlankValidator(this.name, "Contract Name", AuthenticationPolicyContractPaths.getName()));
        this.addValidator((Validator)new AttributeContractValidator<AuthenticationPolicyContractAttribute>(this.coreAttributes, this.extendedAttributes, AuthenticationPolicyContractPaths.getAllAttributes()));
        if (this.isCreate) {
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 33, AuthenticationPolicyContractPaths.getId()));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors()) {
            this.validateNameAndId();
            this.validateCoreAttributes();
        }
        return !this.hasErrors();
    }

    private void validateNameAndId() {
        block3: {
            block2: {
                if (!this.isCreate) break block2;
                if (C_2_C_CONTRACT_MANAGER.isContractNameInUse(null, this.name)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_name_exists, AuthenticationPolicyContractPaths.getName()));
                }
                if (this.id == null || C_2_C_CONTRACT_MANAGER.getContract(this.id) == null) break block3;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_id_exists, AuthenticationPolicyContractPaths.getId()));
                break block3;
            }
            Collection persistedContracts = C_2_C_CONTRACT_MANAGER.getContracts();
            for (C2cContract domainContract : persistedContracts) {
                if (domainContract.getId().equals(this.id) || !domainContract.getName().equals(this.name)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_name_exists, AuthenticationPolicyContractPaths.getName()));
                break;
            }
        }
    }

    private void validateCoreAttributes() {
        AuthenticationPolicyContractAttribute coreAttribute;
        if (this.coreAttributes == null || this.coreAttributes.size() != 1) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_core_attributes_not_valid, AuthenticationPolicyContractPaths.getCoreAttributes()));
        } else if (this.coreAttributes.size() == 1 && !(coreAttribute = this.coreAttributes.get(0)).getName().equals("subject")) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_core_attributes_not_valid, AuthenticationPolicyContractPaths.getCoreAttributes()));
        }
    }

    public static class Builder {
        private boolean isCreate;
        private String apcId;
        private String apcName;
        private List<AuthenticationPolicyContractAttribute> coreAttributes = new ArrayList<AuthenticationPolicyContractAttribute>();
        private List<AuthenticationPolicyContractAttribute> extendedAttributes = new ArrayList<AuthenticationPolicyContractAttribute>();

        public Builder setCreate(boolean isCreate) {
            this.isCreate = isCreate;
            return this;
        }

        public Builder setApcId(String apcId) {
            this.apcId = apcId;
            return this;
        }

        public Builder setApcName(String apcName) {
            this.apcName = apcName;
            return this;
        }

        public Builder setCoreAttributes(List<AuthenticationPolicyContractAttribute> coreAttributes) {
            this.coreAttributes = coreAttributes;
            return this;
        }

        public Builder setExtendedAttributes(List<AuthenticationPolicyContractAttribute> extendedAttributes) {
            this.extendedAttributes = extendedAttributes;
            return this;
        }

        public AuthenticationPolicyContractValidator build() {
            return new AuthenticationPolicyContractValidator(this);
        }
    }
}

