/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationPolicyFragment;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyFragmentPaths;
import com.pingidentity.admin.api.validator.AuthenticationPolicyTreeNodeValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.FragmentInfo;
import com.pingidentity.admin.api.validator.structures.UpstreamSources;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationPolicyFragmentValidator
extends CompositeValidator {
    public static final String RESERVED_FRAGMENT_ID = "inputs";
    private static final C2cContractManager apcManager = MgmtFactory.getC2cContractManager();
    private final AuthenticationPolicyFragment fragment;
    private final ValidatorContext validatorContext;
    protected ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    public AuthenticationPolicyFragmentValidator(AuthenticationPolicyFragment fragment, ValidatorContext context) {
        this.fragment = fragment;
        this.validatorContext = context;
        this.addValidator((Validator)new NotNullValidator(fragment.getRootNode(), "root node", AuthenticationPolicyFragmentPaths.getRootNode()));
        this.addValidator((Validator)new NotBlankValidator(fragment.getName(), "Name", AuthenticationPolicyFragmentPaths.getName()));
        if (fragment.getInputs() != null) {
            this.addValidator((Validator)new ResourceIdValidator(fragment.getInputs(), "Inputs Reference", AuthenticationPolicyFragmentPaths.getInputs()));
        }
        if (fragment.getOutputs() != null) {
            this.addValidator((Validator)new ResourceIdValidator(fragment.getOutputs(), "Outputs Reference", AuthenticationPolicyFragmentPaths.getOutputs()));
        }
        if (!this.validatorContext.isUpdateRequest()) {
            this.addValidator((Validator)new IdValidator(fragment.getId(), true, false, 0, 33, AuthenticationPolicyFragmentPaths.getId()));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors()) {
            if (AuthenticationPolicyFragmentValidator.fragmentIdContainReservedWord(this.fragment.getId())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.fragment_id_reserved_word, AuthenticationPolicyFragmentPaths.getId(), new Object[]{this.fragment.getId()}));
            }
            this.validateDuplicateNameAndID(this.fragment.getName(), this.fragment.getId());
            if (this.fragment.getInputs() != null && apcManager.getContract(this.fragment.getInputs().getId()) == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.fragment_apc_not_found, AuthenticationPolicyFragmentPaths.getInputs(), new Object[]{"inbound", this.fragment.getInputs().getId()}));
            }
            if (this.fragment.getOutputs() != null && apcManager.getContract(this.fragment.getOutputs().getId()) == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.fragment_apc_not_found, AuthenticationPolicyFragmentPaths.getOutputs(), new Object[]{"outbound", this.fragment.getOutputs().getId()}));
            }
            if (!this.validatorContext.isBulkConfigRequest()) {
                List trackedParams = MgmtFactory.getTrackedHttpParamManager().getTrackedParamSettings().getTrackedParamNames();
                String inputContractId = this.fragment.getInputs() != null ? this.fragment.getInputs().getId() : null;
                String outputContractId = this.fragment.getOutputs() != null ? this.fragment.getOutputs().getId() : null;
                FragmentInfo fragmentInfo = new FragmentInfo(inputContractId, outputContractId);
                AuthenticationPolicyTreeNodeValidator validator = new AuthenticationPolicyTreeNodeValidator(AuthenticationPolicyFragmentPaths.getRootNode(), this.fragment.getRootNode(), null, false, false, new UpstreamSources(), true, trackedParams, this.validatorContext, fragmentInfo);
                validator.validate();
                this.appendErrors(validator.getErrors());
            }
        }
        return !this.hasErrors();
    }

    public static boolean fragmentIdContainReservedWord(String id) {
        return RESERVED_FRAGMENT_ID.equalsIgnoreCase(id);
    }

    private void validateDuplicateNameAndID(String name, String id) {
        for (PolicyFragment existingFragment : MgmtFactory.getPolicyFragmentManager().getFragments()) {
            if (existingFragment.getName().equalsIgnoreCase(name) && !StringUtils.equals((String)existingFragment.getId(), (String)id)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.fragment_name_exists, AuthenticationPolicyFragmentPaths.getName(), new Object[]{name}));
                break;
            }
            if (this.validatorContext.isUpdateRequest() || !existingFragment.getId().equalsIgnoreCase(id)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.fragment_id_exists, AuthenticationPolicyFragmentPaths.getId(), new Object[]{id}));
            break;
        }
    }
}

