/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationPolicy;
import com.pingidentity.admin.api.model.AuthenticationPolicyTree;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyPaths;
import com.pingidentity.admin.api.validator.AuthenticationPolicyTreeValidator;
import com.pingidentity.admin.api.validator.AuthenticationSourceValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collections;
import java.util.List;

public class AuthenticationPolicyValidator
extends CompositeValidator {
    private List<AuthenticationPolicyTree> authnSelectionTrees;
    private List<AuthenticationSource> defaultAuthenticationSources;

    public AuthenticationPolicyValidator(AuthenticationPolicy apiPolicy, ValidatorContext context) {
        this.authnSelectionTrees = apiPolicy.getAuthnSelectionTrees();
        this.defaultAuthenticationSources = apiPolicy.getDefaultAuthenticationSources();
        if (apiPolicy.getTrackedHttpParameters() != null && !apiPolicy.getTrackedHttpParameters().isEmpty()) {
            UniqueEntriesValidator.UniqueKeyGetter<String> parameterGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

                @Override
                public String getKey(String object) {
                    return object;
                }
            };
            this.addValidator((Validator)new UniqueEntriesValidator<String>(parameterGetter, apiPolicy.getTrackedHttpParameters(), AuthenticationPolicyPaths.getTrackedHTTPParameters(), ApiMessageKey.authn_policy_tree_tracked_parameters_duplicate));
        }
        int treeIndex = 0;
        if (this.authnSelectionTrees != null && !this.authnSelectionTrees.isEmpty()) {
            for (AuthenticationPolicyTree authenticationPolicyTree : this.authnSelectionTrees) {
                this.addValidator((Validator)new AuthenticationPolicyTreeValidator(AuthenticationPolicyPaths.getAuthnSelectionTrees(treeIndex), authenticationPolicyTree, apiPolicy.getTrackedHttpParameters() != null ? apiPolicy.getTrackedHttpParameters() : Collections.emptyList(), context));
                ++treeIndex;
            }
            this.addValidator((Validator)this.createUniqueIdValidator());
            this.addValidator((Validator)this.createUniqueNameValidator());
        }
        if (this.defaultAuthenticationSources != null && !this.defaultAuthenticationSources.isEmpty()) {
            this.addDuplicateAunthnSourceEntriesValidator();
            int defaultSourcesIndex = 0;
            for (AuthenticationSource authenticationSource : this.defaultAuthenticationSources) {
                this.addValidator((Validator)new AuthenticationSourceValidator(AuthenticationPolicyPaths.getDefaultAuthenticationSources(defaultSourcesIndex), authenticationSource, context));
                ++defaultSourcesIndex;
            }
        }
    }

    UniqueEntriesValidator createUniqueIdValidator() {
        UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyTree> authnTreeIdGetter = new UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyTree>(){

            @Override
            public String getKey(AuthenticationPolicyTree object) {
                if (object.getId() != null) {
                    return object.getId().toLowerCase();
                }
                return null;
            }
        };
        return new UniqueEntriesValidator<AuthenticationPolicyTree>(authnTreeIdGetter, this.authnSelectionTrees, AuthenticationPolicyPaths.getAuthnSelectionTrees(), ApiMessageKey.authn_policy_tree_duplicate_id);
    }

    UniqueEntriesValidator createUniqueNameValidator() {
        UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyTree> authnTreeNameGetter = new UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyTree>(){

            @Override
            public String getKey(AuthenticationPolicyTree object) {
                if (object.getName() != null) {
                    return object.getName();
                }
                return null;
            }
        };
        return new UniqueEntriesValidator<AuthenticationPolicyTree>(authnTreeNameGetter, this.authnSelectionTrees, AuthenticationPolicyPaths.getAuthnSelectionTrees(), ApiMessageKey.authn_policy_tree_duplicate_name);
    }

    private void addDuplicateAunthnSourceEntriesValidator() {
        UniqueEntriesValidator.UniqueKeyGetter<AuthenticationSource> authnSourceKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<AuthenticationSource>(){

            @Override
            public String getKey(AuthenticationSource object) {
                if (object.getSourceRef() != null && object.getSourceRef().getId() != null) {
                    return object.getSourceRef().getId();
                }
                return null;
            }
        };
        this.addValidator((Validator)new UniqueEntriesValidator<AuthenticationSource>(authnSourceKeyGetter, this.defaultAuthenticationSources, AuthenticationPolicyPaths.getDefaultAuthenticationSources(), ApiMessageKey.default_authn_sources_duplicate_entry));
    }
}

