/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationSessionPolicy;
import com.pingidentity.admin.api.model.AuthenticationSourceType;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationSessionPolicyPaths;
import com.pingidentity.admin.api.validator.AuthenticationSessionTimeoutValidator;
import com.pingidentity.admin.api.validator.AuthenticationSourceValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthnSessionPolicy;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SessionTimeUnit;
import org.sourceid.saml20.domain.UserDeviceType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.websso.Protocol;

public class AuthenticationSessionPolicyValidator
extends CompositeValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private boolean isCreate = false;
    private String id;
    private AuthenticationSourceValidator sourceValidator;
    private Boolean enableSessions;
    private UserDeviceType userDeviceType;
    private String idleTimeoutMins;
    private String maxTimeoutMins;
    private SessionTimeUnit timeoutDisplayUnit;
    private boolean authnContextSensitive;
    private AuthnSourceKey authnSourceKey;
    private AuthenticationSessionPolicy policy;

    public AuthenticationSessionPolicyValidator(String id, AuthnSourceKey.AuthnSourceType sourceType, String sourceId, Boolean enableSessions, UserDeviceType userDeviceType, String idleTimeoutMins, String maxTimeoutMins, SessionTimeUnit timeoutDisplayUnit, boolean authnContextSensitive, ValidatorContext context) {
        this.id = id;
        this.enableSessions = enableSessions;
        this.userDeviceType = userDeviceType;
        this.idleTimeoutMins = idleTimeoutMins;
        this.maxTimeoutMins = maxTimeoutMins;
        this.timeoutDisplayUnit = timeoutDisplayUnit;
        this.authnContextSensitive = authnContextSensitive;
        if (AuthnSourceKey.AuthnSourceType.IDP_CONN == sourceType) {
            this.authnSourceKey = new IdpConnAuthnSourceKey(sourceId);
        } else if (AuthnSourceKey.AuthnSourceType.ADAPTER == sourceType) {
            this.authnSourceKey = new AdapterAuthnSourceKey(sourceId);
        }
        this.sourceValidator = new AuthenticationSourceValidator(sourceType, sourceId, context);
        if (StringUtils.isNotBlank((String)idleTimeoutMins) || StringUtils.isNotBlank((String)maxTimeoutMins)) {
            this.addTimeoutValidators(idleTimeoutMins, maxTimeoutMins);
        }
    }

    public AuthenticationSessionPolicyValidator(AuthenticationSessionPolicy policy, boolean isCreate, ValidatorContext context) {
        this.isCreate = isCreate;
        this.id = policy.getId();
        this.policy = policy;
        if (policy.getAuthenticationSource() != null && policy.getAuthenticationSource().getSourceRef() != null) {
            AuthenticationSourceType authenticationSourceType = policy.getAuthenticationSource().getType();
            String sourceId = policy.getAuthenticationSource().getSourceRef().getId();
            if (AuthenticationSourceType.IDP_CONNECTION == authenticationSourceType) {
                this.authnSourceKey = new IdpConnAuthnSourceKey(sourceId);
            } else if (AuthenticationSourceType.IDP_ADAPTER == authenticationSourceType) {
                this.authnSourceKey = new AdapterAuthnSourceKey(sourceId);
            }
        }
        this.sourceValidator = new AuthenticationSourceValidator(AuthenticationSessionPolicyPaths.getAuthenticationSource(), policy.getAuthenticationSource(), context);
        this.enableSessions = policy.isEnableSessions();
        this.userDeviceType = policy.getUserDeviceType();
        this.authnContextSensitive = policy.isAuthnContextSensitive();
        if (policy.getIdleTimeoutMins() != null) {
            this.idleTimeoutMins = policy.getIdleTimeoutMins().toString();
        }
        if (policy.getMaxTimeoutMins() != null) {
            this.maxTimeoutMins = policy.getMaxTimeoutMins().toString();
        }
        this.timeoutDisplayUnit = policy.getTimeoutDisplayUnit();
        if (StringUtils.isNotBlank((String)this.idleTimeoutMins) || StringUtils.isNotBlank((String)this.maxTimeoutMins)) {
            this.addTimeoutValidators(this.idleTimeoutMins, this.maxTimeoutMins);
        }
        if (isCreate && this.id != null) {
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 33, AuthenticationSessionPolicyPaths.getId()));
        }
    }

    private void addTimeoutValidators(String idleTimeoutMins, String maxTimeoutMins) {
        this.addValidator((Validator)new AuthenticationSessionTimeoutValidator(idleTimeoutMins, this.timeoutDisplayUnit, ApiMessageKey.authn_session_policy_invalid_idle_timeout, AuthenticationSessionPolicyPaths.getIdleTimeoutMins()));
        this.addValidator((Validator)new AuthenticationSessionTimeoutValidator(maxTimeoutMins, this.timeoutDisplayUnit, ApiMessageKey.authn_session_policy_invalid_max_timeout, AuthenticationSessionPolicyPaths.getMaxTimeoutMins()));
    }

    @Override
    public boolean validate() {
        this.sourceValidator.validate();
        this.appendErrors(this.sourceValidator.getErrors());
        if (!this.sourceValidator.hasErrors()) {
            IdpConnection conn;
            AuthnSessionPolicy existing = MgmtFactory.getAuthnSessionPolicyManager().getSourcePolicyById(this.id);
            AuthnSourceKey sourceKey = this.sourceValidator.getSourceKey();
            if (existing != null) {
                if (this.isCreate) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_id_exists, AuthenticationSessionPolicyPaths.getId()));
                } else if (!existing.getAuthnSourceKey().equals((Object)sourceKey)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_source_cannot_be_changed, AuthenticationSessionPolicyPaths.getAuthenticationSource()));
                }
            }
            if (sourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN && this.authnContextSensitive && (conn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(sourceKey.getId(), false)) != null && conn.getProtocol() != Protocol.SAML20 && conn.getProtocol() != Protocol.OIDC) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_idp_conn_not_authn_context_sensitive, AuthenticationSessionPolicyPaths.getAuthnContextSensitive()));
            }
            this.validateSessionEnableStatus();
            this.validateUserDevice();
        }
        if (StringUtils.isNotBlank((String)this.idleTimeoutMins) && StringUtils.isBlank((String)this.maxTimeoutMins)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_max_timeout_required, AuthenticationSessionPolicyPaths.getMaxTimeoutMins()));
        }
        if (StringUtils.isNotBlank((String)this.maxTimeoutMins) && StringUtils.isBlank((String)this.idleTimeoutMins)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_idle_timeout_required, AuthenticationSessionPolicyPaths.getIdleTimeoutMins()));
        }
        super.validate();
        if (!this.hasErrors() && StringUtils.isNotBlank((String)this.idleTimeoutMins) && StringUtils.isNotBlank((String)this.maxTimeoutMins)) {
            int idleTimeoutMinsInt = Integer.parseInt(this.idleTimeoutMins);
            int maxTimeoutMinsInt = Integer.parseInt(this.maxTimeoutMins);
            if (maxTimeoutMinsInt != -1 && idleTimeoutMinsInt > maxTimeoutMinsInt) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_max_less_than_idle_timeout, AuthenticationSessionPolicyPaths.getMaxTimeoutMins()));
            }
        }
        return !this.hasErrors();
    }

    private void validateUserDevice() {
        if (this.enableSessions != null && this.enableSessions.booleanValue() && this.policy != null) {
            List existingPolicies;
            if (this.userDeviceType == null) {
                this.userDeviceType = UserDeviceType.getDefaultUserDevice();
            }
            if (!CollectionUtils.isEmpty((Collection)(existingPolicies = MgmtFactory.getAuthnSessionPolicyManager().getSourcePoliciesBySourceKey(this.authnSourceKey)))) {
                for (AuthnSessionPolicy existingPolicy : existingPolicies) {
                    if (!existingPolicy.isEnableSessions() || !this.isCreate && existingPolicy.getId().equals(this.id)) continue;
                    if (this.userDeviceType == existingPolicy.getUserDeviceType()) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_same_user_device_exists, AuthenticationSessionPolicyPaths.getAuthenticationSource(), new Object[]{existingPolicy.getUserDeviceType()}));
                        continue;
                    }
                    if (this.userDeviceType != UserDeviceType.ANY && existingPolicy.getUserDeviceType() != UserDeviceType.ANY) continue;
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_conflicting_user_device_exists, AuthenticationSessionPolicyPaths.getAuthenticationSource(), new Object[]{existingPolicy.getUserDeviceType(), this.userDeviceType}));
                }
            }
        }
    }

    private void validateSessionEnableStatus() {
        if (this.enableSessions == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_enable_sessions_required, AuthenticationSessionPolicyPaths.getEnableSessions()));
        } else if (this.policy != null) {
            List existingPolicies = MgmtFactory.getAuthnSessionPolicyManager().getSourcePoliciesBySourceKey(this.authnSourceKey);
            if (CollectionUtils.isEmpty((Collection)existingPolicies)) {
                return;
            }
            List filteredList = existingPolicies.stream().filter(sessionPolicy -> !sessionPolicy.getId().equals(this.id)).collect(Collectors.toList());
            if (!this.enableSessions.booleanValue()) {
                if (CollectionUtils.isNotEmpty((Collection)existingPolicies)) {
                    if (filteredList.stream().anyMatch(sessionPolicy -> !sessionPolicy.isEnableSessions())) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_disable_sessions_duplicate, AuthenticationSessionPolicyPaths.getEnableSessions(), new Object[]{this.authnSourceKey}));
                    }
                    if (filteredList.stream().anyMatch(AuthnSessionPolicy::isEnableSessions)) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_disable_sessions_invalid, AuthenticationSessionPolicyPaths.getEnableSessions(), new Object[]{this.authnSourceKey}));
                    }
                }
            } else if (filteredList.stream().anyMatch(policy -> !policy.isEnableSessions())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_enable_sessions_invalid, AuthenticationSessionPolicyPaths.getEnableSessions(), new Object[]{this.authnSourceKey}));
            }
        }
    }
}

