/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.concurrent.TimeUnit;
import org.sourceid.saml20.domain.SessionTimeUnit;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationSessionTimeoutValidator
extends AbstractValidator {
    private int MIN_TIMEOUT_MINS = 1;
    private int MAX_TIMEOUT_DAYS = MgmtFactory.getAuthnSessionPolicyManager().getTimeoutCapDays();
    private int MAX_TIMEOUT_MINS = this.MAX_TIMEOUT_DAYS * 24 * 60;
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private String value;
    private ApiMessageKey msgKey;
    private String fieldPath;
    private SessionTimeUnit displayUnit = SessionTimeUnit.MINUTES;

    public AuthenticationSessionTimeoutValidator(String value, SessionTimeUnit displayUnit, ApiMessageKey msgKey, String fieldPath) {
        this.value = value;
        if (displayUnit != null) {
            this.displayUnit = displayUnit;
        }
        this.msgKey = msgKey;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        if (this.value != null) {
            try {
                int timeoutMins = Integer.parseInt(this.value);
                if (timeoutMins != -1) {
                    if (timeoutMins < this.MIN_TIMEOUT_MINS || timeoutMins > this.MAX_TIMEOUT_MINS) {
                        this.appendMinMaxError();
                    } else if (this.displayUnit != SessionTimeUnit.MINUTES && timeoutMins % this.displayUnit.getMinutesPerUnit() != 0) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_timeout_must_be_multiple, this.fieldPath, new Object[]{this.displayUnit, this.displayUnit.getMinutesPerUnit()}));
                    }
                }
            }
            catch (NumberFormatException e) {
                this.appendMinMaxError();
            }
        }
        return !this.hasErrors();
    }

    private void appendMinMaxError() {
        this.appendError(this.errorFactory.create(this.msgKey, this.fieldPath, new Object[]{this.MIN_TIMEOUT_MINS, this.MAX_TIMEOUT_MINS, this.displayUnit.toTimeUnit().convert(this.MAX_TIMEOUT_DAYS, TimeUnit.DAYS), this.displayUnit.toString().toLowerCase()}));
    }
}

