/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SessionTimeoutPolicy;
import com.pingidentity.admin.api.validator.AuthenticationSessionTimeoutValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.sourceid.saml20.domain.SessionTimeUnit;

public abstract class AuthenticationSessionValidator
extends CompositeValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    protected String idleTimeoutMins;
    protected String maxTimeoutMins;

    public AuthenticationSessionValidator(String idleTimeoutMins, SessionTimeUnit idleTimeoutDisplayUnit, String maxTimeoutMins, SessionTimeUnit maxTimeoutDisplayUnit) {
        this.addValidators(idleTimeoutMins, idleTimeoutDisplayUnit, maxTimeoutMins, maxTimeoutDisplayUnit);
    }

    public AuthenticationSessionValidator(SessionTimeoutPolicy policy, SessionTimeUnit idleTimeoutDisplayUnit, SessionTimeUnit maxTimeoutDisplayUnit) {
        String idleTimeoutMins = null;
        if (policy.getIdleTimeoutMins() != null) {
            idleTimeoutMins = policy.getIdleTimeoutMins().toString();
        }
        String maxTimeoutMins = null;
        if (policy.getMaxTimeoutMins() != null) {
            maxTimeoutMins = policy.getMaxTimeoutMins().toString();
        }
        this.addValidators(idleTimeoutMins, idleTimeoutDisplayUnit, maxTimeoutMins, maxTimeoutDisplayUnit);
    }

    private void addValidators(String idleTimeoutMins, SessionTimeUnit idleTimeoutDisplayUnit, String maxTimeoutMins, SessionTimeUnit maxTimeoutDisplayUnit) {
        this.addValidator((Validator)new AuthenticationSessionTimeoutValidator(idleTimeoutMins, idleTimeoutDisplayUnit, ApiMessageKey.authn_session_policy_invalid_idle_timeout, this.getIdleTimeoutPath()));
        this.addValidator((Validator)new AuthenticationSessionTimeoutValidator(maxTimeoutMins, maxTimeoutDisplayUnit, ApiMessageKey.authn_session_policy_invalid_max_timeout, this.getMaxTimeoutPath()));
        this.idleTimeoutMins = idleTimeoutMins;
        this.maxTimeoutMins = maxTimeoutMins;
        if (this.idleTimeoutMins == null) {
            this.idleTimeoutMins = Integer.toString(this.getDefaultIdleTimeout());
        }
        if (this.maxTimeoutMins == null) {
            this.maxTimeoutMins = Integer.toString(this.getDefaultMaxTimeout());
        }
    }

    public abstract String getIdleTimeoutPath();

    public abstract String getMaxTimeoutPath();

    public abstract Integer getDefaultIdleTimeout();

    public abstract Integer getDefaultMaxTimeout();

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors()) {
            int idleTimeoutMinsInt = Integer.parseInt(this.idleTimeoutMins);
            int maxTimeoutMinsInt = Integer.parseInt(this.maxTimeoutMins);
            if (maxTimeoutMinsInt != -1 && idleTimeoutMinsInt > maxTimeoutMinsInt) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_session_policy_max_less_than_idle_timeout, this.getMaxTimeoutPath()));
            }
        }
        return !this.hasErrors();
    }
}

