/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.AttributeContract;

public class AuthenticationSourceMappingsValidator
extends BaseAttributeDataSourceValidator {
    protected final SpBrowserSso browserSso;
    protected final List<String> availableVirtualServerIds;

    public AuthenticationSourceMappingsValidator(SpBrowserSso browserSso) {
        this(browserSso, Collections.emptyList(), null);
    }

    public AuthenticationSourceMappingsValidator(SpBrowserSso browserSso, List<String> availableVirtualServerIds, ValidatorContext context) {
        super(context);
        this.browserSso = browserSso;
        this.availableVirtualServerIds = availableVirtualServerIds;
    }

    protected AttributeSetSourceTypeValidatorBuilder createAssertionValBuilder(SpBrowserSso browserSso) {
        HashSet<String> assertionAttributes = new HashSet<String>();
        Object domainAssertionContract = this.isTransient(browserSso) ? new AssertionAttributeContract(false, true) : (this.isPersistent(browserSso) ? new AssertionAttributeContract(true, false) : (browserSso.getProtocol() == Protocol.WSFED && browserSso.getWsFedTokenType() == WsFedTokenType.JWT ? new AttributeContract() : new AssertionAttributeContract()));
        assertionAttributes.addAll(domainAssertionContract.getImmutableAttributeNames());
        for (SpBrowserSsoAttribute exAttr : browserSso.getAttributeContract().getExtendedAttributes()) {
            if (exAttr.getName() == null) continue;
            assertionAttributes.add(exAttr.getName());
        }
        return new AttributeSetSourceTypeValidatorBuilder(assertionAttributes, SourceType.ASSERTION);
    }

    protected boolean isTransient(SpBrowserSso browserSso) {
        return browserSso.getSpSamlIdentityMapping() != null && browserSso.getSpSamlIdentityMapping().getNameIdFormatUri().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
    }

    protected boolean isPersistent(SpBrowserSso browserSso) {
        return browserSso.getSpSamlIdentityMapping() != null && browserSso.getSpSamlIdentityMapping().getNameIdFormatUri().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
    }

    protected ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        return null;
    }

    public static TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    protected boolean isSourceContainsFulfillment(List<AttributeSource> sources) {
        for (AttributeSource source : sources) {
            if (source == null || source.getAttributeContractFulfillment() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean validateAttrSourceAttrContractFulfillments(List<AttributeSource> apiAttributeSources, String mappingPath) {
        int totalAttributeSources = apiAttributeSources.size();
        int attrSourcesWithAttrContractFulfillments = 0;
        for (AttributeSource attributeSource : apiAttributeSources) {
            if (attributeSource == null || attributeSource.getAttributeContractFulfillment() == null) continue;
            ++attrSourcesWithAttrContractFulfillments;
        }
        if (attrSourcesWithAttrContractFulfillments != 0 && totalAttributeSources != attrSourcesWithAttrContractFulfillments) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_assertion_mappings_invalid_number_attribute_contract_fulfillment, mappingPath));
        }
        return !this.hasErrors();
    }
}

