/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationSourcePaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.sourceid.saml20.domain.AuthnSessionPolicy;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;

public class AuthenticationSourceValidator
extends AbstractValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private String rootFieldPath = null;
    private AuthnSourceKey.AuthnSourceType sourceType;
    private String sourceId;
    private ValidatorContext context;

    public AuthenticationSourceValidator(AuthnSourceKey.AuthnSourceType sourceType, String sourceId, ValidatorContext context) {
        this.sourceType = sourceType;
        this.sourceId = sourceId;
        this.context = context;
    }

    public AuthenticationSourceValidator(String rootFieldPath, AuthenticationSource apiSource, ValidatorContext context) {
        this.rootFieldPath = rootFieldPath;
        if (apiSource != null) {
            if (apiSource.getType() != null) {
                this.sourceType = apiSource.getType().toDomain();
            }
            if (apiSource.getSourceRef() != null) {
                this.sourceId = apiSource.getSourceRef().getId();
            }
        }
        this.context = context;
    }

    public boolean validate() {
        if (this.sourceType == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_type_required, this.makeFieldPath(AuthenticationSourcePaths.getType())));
        } else if (this.sourceId == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_id_required, this.makeFieldPath(AuthenticationSourcePaths.getSourceRefId())));
        } else {
            this.checkAuthnSourceExists(this.sourceType, this.sourceId);
        }
        return !this.hasErrors();
    }

    public AuthnSourceKey getSourceKey() {
        return AuthnSessionPolicy.makeAuthnSourceKey((AuthnSourceKey.AuthnSourceType)this.sourceType, (String)this.sourceId);
    }

    private void checkAuthnSourceExists(AuthnSourceKey.AuthnSourceType sourceType, String sourceId) {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        switch (sourceType) {
            case ADAPTER: {
                if (!localSettings.isEnableIdP()) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_type_invalid, this.makeFieldPath(AuthenticationSourcePaths.getType())));
                    break;
                }
                IdpAuthnAdapterInstance adapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(sourceId);
                if (adapter != null && adapter.getId().equals(sourceId) && !adapter.isConnectionBasedPlugin()) break;
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_id_invalid, this.makeFieldPath(AuthenticationSourcePaths.getSourceRefId())));
                break;
            }
            case IDP_CONN: {
                if (!localSettings.isEnableSP()) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_type_invalid, this.makeFieldPath(AuthenticationSourcePaths.getType())));
                    break;
                }
                IdpConnection conn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(sourceId, false);
                if (conn != null && (conn.getEnabledProfiles().isIdpInitiatedSSOEnabled() || conn.getEnabledProfiles().isSpInitiatedSSOEnabled())) break;
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_source_id_invalid, this.makeFieldPath(AuthenticationSourcePaths.getSourceRefId())));
                break;
            }
            case FRAGMENT: {
                PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(sourceId);
                if (fragment != null || this.context.isBulkConfigRequest()) break;
                this.appendError(this.errorFactory.create(ApiMessageKey.fragment_id_invalid, this.makeFieldPath(AuthenticationSourcePaths.getSourceRefId())));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected AuthnSourceType: " + sourceType);
            }
        }
    }

    private String makeFieldPath(String suffix) {
        if (this.rootFieldPath == null) {
            return suffix;
        }
        return this.rootFieldPath + "." + suffix;
    }
}

