/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.DsSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Map;
import org.sourceid.saml20.domain.SourceContextType;

public class BaseAttributeDataSourceValidator
extends CompositeValidator {
    private ValidatorContext context;

    public BaseAttributeDataSourceValidator(ValidatorContext context) {
        this.context = context;
    }

    protected DsSourceTypeValidatorBuilder createDsValBuilder(SourceType attrSourceType, AttributeMapping mapping) {
        for (AttributeSource source : mapping.getAttributeSources()) {
            if (source == null || !(source.getType() == DataStoreType.LDAP && attrSourceType == SourceType.LDAP_DATA_STORE || source.getType() == DataStoreType.JDBC && attrSourceType == SourceType.JDBC_DATA_STORE) && (source.getType() != DataStoreType.CUSTOM || attrSourceType != SourceType.CUSTOM_DATA_STORE)) continue;
            DsSourceTypeValidatorBuilder builder = new DsSourceTypeValidatorBuilder(this.context);
            builder.setAttributeSource(source);
            builder.setSourceType(attrSourceType);
            return builder;
        }
        return null;
    }

    protected DsSourceTypeValidatorBuilder createDsValBuilder(SourceType attrSourceType, AttributeSource source) {
        if (source != null && (source.getType() == DataStoreType.LDAP && attrSourceType == SourceType.LDAP_DATA_STORE || source.getType() == DataStoreType.JDBC && attrSourceType == SourceType.JDBC_DATA_STORE || source.getType() == DataStoreType.CUSTOM && attrSourceType == SourceType.CUSTOM_DATA_STORE)) {
            DsSourceTypeValidatorBuilder builder = new DsSourceTypeValidatorBuilder(this.context);
            builder.setAttributeSource(source);
            builder.setSourceType(attrSourceType);
            return builder;
        }
        return null;
    }

    protected void mapDataStoreTypesToDsValidators(AttributeMapping attributeMapping, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        for (AttributeSource attributeSource : attributeMapping.getAttributeSources()) {
            if (attributeSource == null || attributeSource.getType() == null) continue;
            switch (attributeSource.getType()) {
                case LDAP: {
                    validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE, attributeSource.getId()), this.createDsValBuilder(SourceType.LDAP_DATA_STORE, attributeSource));
                    break;
                }
                case JDBC: {
                    validSources.put(new SourceTypeIdKey(SourceType.JDBC_DATA_STORE, attributeSource.getId()), this.createDsValBuilder(SourceType.JDBC_DATA_STORE, attributeSource));
                    break;
                }
                case CUSTOM: {
                    validSources.put(new SourceTypeIdKey(SourceType.CUSTOM_DATA_STORE, attributeSource.getId()), this.createDsValBuilder(SourceType.CUSTOM_DATA_STORE, attributeSource));
                    break;
                }
            }
        }
    }

    protected void mapDataStoreTypeToDsValidator(AttributeSource attributeSource, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        if (attributeSource != null && attributeSource.getType() != null) {
            switch (attributeSource.getType()) {
                case LDAP: {
                    validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE, attributeSource.getId()), this.createDsValBuilder(SourceType.LDAP_DATA_STORE, attributeSource));
                    break;
                }
                case JDBC: {
                    validSources.put(new SourceTypeIdKey(SourceType.JDBC_DATA_STORE, attributeSource.getId()), this.createDsValBuilder(SourceType.JDBC_DATA_STORE, attributeSource));
                    break;
                }
                case CUSTOM: {
                    validSources.put(new SourceTypeIdKey(SourceType.CUSTOM_DATA_STORE, attributeSource.getId()), this.createDsValBuilder(SourceType.CUSTOM_DATA_STORE, attributeSource));
                    break;
                }
            }
        }
    }

    public ValidatorContext getContext() {
        return this.context;
    }

    public void setContext(ValidatorContext context) {
        this.context = context;
    }

    protected ContextSourceTypeValidatorBuilder createAuthnPolicyContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForAuthnPolicy());
        return builder;
    }
}

