/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.BaseSigningSettings;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.model.fieldpaths.CredentialsPath;
import com.pingidentity.admin.api.model.fieldpaths.SigningSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SignatureAlgorithm;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.crypto.WsfedJwtSigningAlgorithms;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class BaseSigningSettingsValidator
extends AbstractValidator {
    private final BaseSigningSettings signingSettings;
    private final boolean allowEmptySettings;
    private final String baseFieldPath;
    private WsFedTokenType tokenType = null;
    private Protocol protocol;
    private boolean fullValidationPath;

    public BaseSigningSettingsValidator(BaseSigningSettings signingSettings, boolean allowEmptySettings, String baseFieldPath, boolean fullValidationPath) {
        this.signingSettings = signingSettings;
        this.allowEmptySettings = allowEmptySettings;
        this.baseFieldPath = baseFieldPath;
        this.protocol = null;
        this.fullValidationPath = fullValidationPath;
    }

    public BaseSigningSettingsValidator(BaseSigningSettings signingSettings, boolean allowEmptySettings, String baseFieldPath, Protocol protocol, WsFedTokenType tokenType, boolean fullValidationPath) {
        this(signingSettings, allowEmptySettings, baseFieldPath, fullValidationPath);
        this.protocol = protocol;
        this.tokenType = tokenType;
        this.fullValidationPath = fullValidationPath;
    }

    public boolean validate() {
        if (this.signingSettings == null && !this.allowEmptySettings || this.signingSettings != null && (this.signingSettings.getSigningKeyPairRef() == null || this.signingSettings.getSigningKeyPairRef().getId() == null)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_key_pair_required, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getSigningKeyPairId())));
        }
        if (this.hasErrors()) {
            return false;
        }
        if (this.signingSettings != null) {
            this.validateSigningKeyCertAndAlgorithm(this.signingSettings);
        }
        return !this.hasErrors();
    }

    private void validateSigningKeyCertAndAlgorithm(BaseSigningSettings signingSettings) {
        String signingKeyCertId = signingSettings.getSigningKeyPairRef().getId();
        PkCert pkCert = MgmtFactory.getDsigPkCertManager().getPkCert(signingKeyCertId);
        if (pkCert == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_key_pair_not_found, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getSigningKeyPairId()), new Object[]{signingKeyCertId}));
        } else {
            SignatureAlgorithms sigAlgUtils = SignatureAlgorithms.getInstance();
            String publicKeyAlgorithm = pkCert.getX509Certificate().getPublicKey().getAlgorithm();
            String requestedAlgorithm = signingSettings.getAlgorithm();
            if (requestedAlgorithm == null) {
                SignatureAlgorithm defaultAlgorithm = sigAlgUtils.getDefaultSignatureAlgorithmOfType(publicKeyAlgorithm);
                if (defaultAlgorithm != null) {
                    signingSettings.setAlgorithm(defaultAlgorithm.getNameForRuntime());
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_algorithm_required, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getSigningAlgorithm())));
                }
            } else if (this.protocol == Protocol.WSFED && this.tokenType == WsFedTokenType.JWT) {
                if (WsfedJwtSigningAlgorithms.nameToAlg((String)requestedAlgorithm) == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_algorithm_invalid, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getSigningAlgorithm())));
                }
            } else {
                List algorithms = SignatureAlgorithms.getInstance().getSupportedSignatureAlgorithms(publicKeyAlgorithm);
                SignatureAlgorithm algorithm = this.findAlgorithmByName(algorithms, requestedAlgorithm);
                if (algorithm == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_algorithm_invalid, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getSigningAlgorithm())));
                }
            }
            if (this.protocol == Protocol.WSFED) {
                if (WsFedTokenType.JWT.equals((Object)this.tokenType) && signingSettings.isIncludeRawKeyInSignature().booleanValue()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, CredentialsPath.getIncludeRawKeyInSignature(this.fullValidationPath), new Object[]{CredentialsPath.getIncludeRawKeyInSignature(this.fullValidationPath)}));
                }
                if (signingSettings.isIncludeCertInSignature() != null && signingSettings.isIncludeCertInSignature().booleanValue()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, CredentialsPath.getIncludeCertInSignature(this.fullValidationPath), new Object[]{CredentialsPath.getIncludeCertInSignature(this.fullValidationPath)}));
                }
            } else if (signingSettings.isIncludeCertInSignature() == null || !signingSettings.isIncludeCertInSignature().booleanValue() && signingSettings.isIncludeRawKeyInSignature().booleanValue()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_must_include_cert_to_include_raw_key, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getIncludeRawKeyInSignature())));
            }
            if ("EC".equals(publicKeyAlgorithm) && signingSettings.isIncludeRawKeyInSignature().booleanValue()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_cannot_include_raw_key_for_ec, this.appendFieldPath(this.baseFieldPath, SigningSettingsPaths.getIncludeRawKeyInSignature())));
            }
        }
    }

    private SignatureAlgorithm findAlgorithmByName(List<SignatureAlgorithm> algorithms, String name) {
        for (SignatureAlgorithm algorithm : algorithms) {
            if (!algorithm.getNameForRuntime().equals(name)) continue;
            return algorithm;
        }
        return null;
    }

    public String appendFieldPath(String basePath, String append) {
        if (this.fullValidationPath) {
            return super.appendFieldPath(basePath, append);
        }
        return append;
    }
}

