/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class CIBADefaultsValidator
extends AbstractValidator {
    private String cibaPollingInterval;

    public CIBADefaultsValidator(String cibaPollingInterval) {
        this.cibaPollingInterval = cibaPollingInterval;
    }

    public boolean validate() {
        String ciba_polling_interval = "CIBA Polling Interval";
        if (StringUtils.isNotBlank((String)this.cibaPollingInterval)) {
            IntegerValidator pollingIntervalValidator = new IntegerValidator(this.cibaPollingInterval, "CIBA Polling Interval", ClientSettingsPaths.getCibaPollingInterval(), false, 1, 3600);
            if (!pollingIntervalValidator.validate()) {
                this.appendErrors(pollingIntervalValidator.getErrors());
            }
        } else {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ClientSettingsPaths.getCibaPollingInterval(), new Object[]{"CIBA Polling Interval"}));
        }
        return !this.hasErrors();
    }
}

