/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.CaptchaProvidersSettingsPath;
import com.pingidentity.admin.api.model.plugin.CaptchaProvidersSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.mgmt.CaptchaProviderPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CaptchaProvidersSettingsValidator
extends AbstractValidator {
    private final CaptchaProvidersSettings settings;
    private CaptchaProviderInstance defaultInstanceToUpdate = null;

    public CaptchaProvidersSettingsValidator(CaptchaProvidersSettings settings) {
        this.settings = settings;
    }

    public boolean validate() {
        CaptchaProviderPluginManager pluginManager = MgmtFactory.getCaptchaProviderPluginManager();
        if (this.settings.getDefaultCaptchaProviderRef() != null && this.settings.getDefaultCaptchaProviderRef().getId() != null) {
            String defaultInstanceId = this.settings.getDefaultCaptchaProviderRef().getId();
            this.defaultInstanceToUpdate = (CaptchaProviderInstance)pluginManager.getInstance(defaultInstanceId);
            if (this.defaultInstanceToUpdate == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_provider_default_provider_invalid, CaptchaProvidersSettingsPath.getDefaultCaptchaProviderRefId(), new Object[]{defaultInstanceId}));
            }
        } else if (!pluginManager.getInstances().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_provider_default_provider_required, CaptchaProvidersSettingsPath.getDefaultCaptchaProviderRef()));
        }
        return !this.hasErrors();
    }

    public CaptchaProviderInstance getDefaultInstance() {
        return this.defaultInstanceToUpdate;
    }
}

