/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.CaptchaSettingsPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.ObfuscationException;
import org.apache.commons.lang.StringUtils;

public class CaptchaSettingsValidator
extends CompositeValidator {
    private String siteKey;
    private String secretKey;
    private String encryptedSecretKey;

    private CaptchaSettingsValidator(Builder builder) {
        this.siteKey = builder.siteKey;
        this.secretKey = builder.secretKey;
        this.encryptedSecretKey = builder.encryptedSecretKey;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (StringUtils.isBlank((String)this.siteKey)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_settings_site_key_required, CaptchaSettingsPaths.getSiteKey()));
        }
        if (StringUtils.isBlank((String)this.secretKey) && StringUtils.isBlank((String)this.encryptedSecretKey)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_settings_secret_key_required, CaptchaSettingsPaths.getSecretKey()));
        }
        if (StringUtils.isNotEmpty((String)this.encryptedSecretKey)) {
            try {
                if (FieldObfuscator.REAL.deobfuscate(this.encryptedSecretKey) == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_settings_invalid_encrypted_secret_key, CaptchaSettingsPaths.getEncryptedSecretKey()));
                }
            }
            catch (ObfuscationException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.captcha_settings_invalid_encrypted_secret_key, CaptchaSettingsPaths.getEncryptedSecretKey()));
            }
        }
        return !this.hasErrors();
    }

    public static class Builder {
        String siteKey;
        String secretKey;
        String encryptedSecretKey;

        public Builder setSiteKey(String siteKey) {
            this.siteKey = siteKey;
            return this;
        }

        public Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder setEncryptedSecretKey(String encryptedSecretKey) {
            this.encryptedSecretKey = encryptedSecretKey;
            return this;
        }

        public CaptchaSettingsValidator build() {
            return new CaptchaSettingsValidator(this);
        }
    }
}

