/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Channel;
import com.pingidentity.admin.api.model.Schema;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.ChannelSourceValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.SaasAttributeMappingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ChannelValidator
extends CompositeValidator {
    private static final Log log = LogFactory.getLog(ChannelValidator.class);
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private SaasProvisionerPlugin pluginInstance;
    private Channel channel;
    private int index;
    private Set<String> ldapNames = new HashSet<String>();
    private List<SchemaAttribute> schemaAtributes;
    private com.pingidentity.provisioner.domain.Channel existingChannel;
    private ValidatorContext context;

    ChannelValidator(SaasProvisionerPlugin pluginInstance, int index, Channel channel, Schema schema, com.pingidentity.provisioner.domain.Channel existingChannel, ValidatorContext context) {
        LdapDataSource ldapDataSource;
        this.pluginInstance = pluginInstance;
        this.channel = channel;
        this.index = index;
        this.schemaAtributes = schema == null ? null : schema.getAttributes();
        this.existingChannel = existingChannel;
        this.context = context;
        if (!context.isBypassExternalValidation() && channel.getChannelSource() != null && channel.getChannelSource().getDataSource() != null && (ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(channel.getChannelSource().getDataSource().getId())) != null) {
            this.ldapNames = new HashSet<String>(ldapDataSource.getLDAPAttributeNameList());
        }
        this.addValidator((Validator)new NotBlankValidator(channel.getName(), ConnectionPaths.OutboundProvisionPaths.getChannelName(index), ConnectionPaths.OutboundProvisionPaths.getChannelName(index)));
        this.addValidator((Validator)new NotNullValidator(channel.getAttributeMapping(), ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappings(index), ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappings(index)));
        this.addValidator((Validator)new NotNullValidator(channel.getChannelSource(), ConnectionPaths.OutboundProvisionPaths.getChannelSource(index), ConnectionPaths.OutboundProvisionPaths.getChannelSource(index)));
        this.addValidator((Validator)new NotNullValidator(channel.getMaxThreads(), ConnectionPaths.OutboundProvisionPaths.getMaxThreads(index), ConnectionPaths.OutboundProvisionPaths.getMaxThreads(index)));
        this.addValidator((Validator)new NotNullValidator(channel.getTimeout(), ConnectionPaths.OutboundProvisionPaths.getTimeout(index), ConnectionPaths.OutboundProvisionPaths.getTimeout(index)));
        if (channel.getChannelSource() != null) {
            this.addValidator((Validator)new ChannelSourceValidator(index, channel));
        }
    }

    @Override
    public boolean validate() {
        ValidationError error;
        if (this.existingChannel != null && this.existingChannel.isActive() && this.channel.getChannelSource() != null && this.channel.getChannelSource().getDataSource() != null && !this.existingChannel.getSource().getDataSourceId().equals(this.channel.getChannelSource().getDataSource().getId())) {
            error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_datastore_change_active_channel, ConnectionPaths.OutboundProvisionPaths.getDataSourceId(this.index));
            this.appendError(error);
        }
        if (this.channel.getTimeout() < 1) {
            error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_timeout_invalid, ConnectionPaths.OutboundProvisionPaths.getTimeout(this.index), new Object[]{this.channel.getTimeout()});
            this.appendError(error);
        }
        if (this.channel.getMaxThreads() < 1 || this.channel.getMaxThreads() > 10000) {
            error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_max_thread_invalid, ConnectionPaths.OutboundProvisionPaths.getMaxThreads(this.index), new Object[]{this.channel.getMaxThreads()});
            this.appendError(error);
        }
        if (super.validate() && !this.hasErrors()) {
            try {
                SaasAttributeMappingsValidator validator = new SaasAttributeMappingsValidator(this.index, this.channel.getAttributeMapping(), this.pluginInstance.getFieldsInfo(), this.ldapNames, this.schemaAtributes, this.context);
                validator.validate();
                this.appendErrors(validator.getErrors());
            }
            catch (SaasException e) {
                ValidationError error2 = this.errorFactory.create(ApiMessageKey.outbound_provisioning_plugin_load_failed, ConnectionPaths.getOutboundProvision());
                this.appendError(error2);
                log.debug((Object)e.getMessage());
            }
        }
        return !this.hasErrors();
    }
}

