/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.AuthorizationServerSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class ClientSecretRetentionPeriodValidator
extends AbstractValidator {
    private static final int CLIENT_SECRET_RETENTION_PERIOD_MIN_VALUE = 0;
    private static final int CLIENT_SECRET_RETENTION_PERIOD_MAX_VALUE = 43800;
    private static final String CLIENT_SECRET_RETENTION_PERIOD_NAME = "Client Secret Retention Period";
    private final String clientSecretRetentionPeriodType;
    private final String clientSecretRetentionPeriod;
    private final String clientSecretRetentionPeriodFieldPath;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    public ClientSecretRetentionPeriodValidator(String clientSecretRetentionPeriodType, String clientSecretRetentionPeriod, String clientSecretRetentionPeriodFieldPath) {
        this.clientSecretRetentionPeriodType = clientSecretRetentionPeriodType;
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
        this.clientSecretRetentionPeriodFieldPath = clientSecretRetentionPeriodFieldPath;
    }

    public ClientSecretRetentionPeriodValidator(String clientSecretRetentionPeriodType, String clientSecretRetentionPeriod) {
        this(clientSecretRetentionPeriodType, clientSecretRetentionPeriod, AuthorizationServerSettingsPaths.getClientSecretRetentionPeriodPath());
    }

    public ClientSecretRetentionPeriodValidator(String clientSecretRetentionPeriod) {
        this("OVERRIDE_SERVER_DEFAULT", clientSecretRetentionPeriod, AuthorizationServerSettingsPaths.getClientSecretRetentionPeriodPath());
    }

    public boolean validate() {
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.clientSecretRetentionPeriodType)) {
            IntegerValidator retentionPeriodLengthValidator = new IntegerValidator(this.clientSecretRetentionPeriod, CLIENT_SECRET_RETENTION_PERIOD_NAME, this.clientSecretRetentionPeriodFieldPath, true, 0, 43800);
            if (!retentionPeriodLengthValidator.validate()) {
                this.appendErrors(retentionPeriodLengthValidator.getErrors());
            }
        } else if ("SERVER_DEFAULT".equals(this.clientSecretRetentionPeriodType) && StringUtils.isNotBlank((String)this.clientSecretRetentionPeriod)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_client_secret_retention_period_type_mismatch, this.clientSecretRetentionPeriodFieldPath));
        }
        return !this.hasErrors();
    }
}

