/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.model.oauth.ClientMetadata;
import com.pingidentity.admin.api.model.oauth.ClientSettings;
import com.pingidentity.admin.api.model.oauth.DynamicClientRegistration;
import com.pingidentity.admin.api.validator.ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator;
import com.pingidentity.admin.api.validator.ClientSecretRetentionPeriodValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ExtendedPropertiesValidator;
import com.pingidentity.admin.api.validator.OAuthClientDefaultsValidator;
import com.pingidentity.admin.api.validator.OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsValidator;
import com.pingidentity.admin.api.validator.OAuthDynamicClientRegistrationPoliciesValidator;
import com.pingidentity.admin.api.validator.OAuthDynamicClientRegistrationScopeConstraintsValidator;
import com.pingidentity.admin.api.validator.OAuthDynamicClientRegistrationValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientSettingsValidator
extends CompositeValidator {
    public ClientSettingsValidator(ClientSettings clientSettings) {
        List<ClientMetadata> clientMetadataList = clientSettings.getClientMetadata();
        LinkedHashMap<String, String> clientMetadataMap = new LinkedHashMap<String, String>();
        if (clientMetadataList != null) {
            int i = 0;
            for (ClientMetadata clientMetadata : clientMetadataList) {
                if (clientMetadataMap.containsKey(clientMetadata.getParameter())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.extended_property_duplicate_name, ClientSettingsPaths.getMetadataParameter(i), new Object[]{clientMetadata.getParameter()}));
                } else {
                    clientMetadataMap.put(clientMetadata.getParameter(), clientMetadata.getDescription());
                }
                ++i;
            }
        }
        if (!this.hasErrors()) {
            ExtendedPropertiesValidator metadataValidator = new ExtendedPropertiesValidator(clientMetadataMap);
            this.addValidator((Validator)metadataValidator);
        }
        if (clientSettings.getDynamicClientRegistration() != null) {
            CibaServerPolicy policy;
            Map policyGroups;
            String cibaPolicyId;
            DynamicClientRegistration dynamicClientReg = clientSettings.getDynamicClientRegistration();
            if (dynamicClientReg.getInitialAccessTokenScope() != null) {
                OAuthDynamicClientRegistrationValidator dynamicClientValidator = new OAuthDynamicClientRegistrationValidator(true, true, dynamicClientReg.getInitialAccessTokenScope());
                this.addValidator((Validator)dynamicClientValidator);
            }
            OAuthDynamicClientRegistrationScopeConstraintsValidator scopeConstraintsValidator = new OAuthDynamicClientRegistrationScopeConstraintsValidator(clientSettings);
            this.addValidator((Validator)scopeConstraintsValidator);
            OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsValidator authorizationDetailConstraintsValidator = new OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsValidator(clientSettings);
            this.addValidator((Validator)authorizationDetailConstraintsValidator);
            OAuthClientDefaultsValidator defaultsValidator = new OAuthClientDefaultsValidator(clientSettings);
            this.addValidator((Validator)defaultsValidator);
            OAuthDynamicClientRegistrationPoliciesValidator policiesValidator = new OAuthDynamicClientRegistrationPoliciesValidator(dynamicClientReg.getPolicyRefs());
            this.addValidator((Validator)policiesValidator);
            ClientSecretRetentionPeriodValidator clientSecretRetentionPeriodValidator = new ClientSecretRetentionPeriodValidator(dynamicClientReg.getClientSecretRetentionPeriodType(), dynamicClientReg.getClientSecretRetentionPeriodOverride() != null ? String.valueOf(dynamicClientReg.getClientSecretRetentionPeriodOverride()) : null);
            this.addValidator((Validator)clientSecretRetentionPeriodValidator);
            String requireOfflineAccessScopeToIssueRefreshTokens = dynamicClientReg.getRequireOfflineAccessScopeToIssueRefreshTokens() != null ? dynamicClientReg.getRequireOfflineAccessScopeToIssueRefreshTokens().getValue() : null;
            String requireOfflineAccessScopeToIssueRefreshTokensPath = ClientSettingsPaths.getRequireOfflineAccessScopeToIssueRefreshTokensPath();
            this.addValidator((Validator)new ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator(requireOfflineAccessScopeToIssueRefreshTokens, requireOfflineAccessScopeToIssueRefreshTokensPath));
            if (dynamicClientReg.getRequestPolicyRef() != null && StringUtils.isNotEmpty((String)(cibaPolicyId = dynamicClientReg.getRequestPolicyRef().getId())) && !(policyGroups = (policy = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy()).getRequestHandlingPolicies()).containsKey(cibaPolicyId)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_mgmt_group_policy_invalid, ClientSettingsPaths.getCibaRequestPolicyRef(), new Object[]{"CIBA Policy ID"}));
            }
        }
    }
}

