/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionMetadataUrl;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.mgmt.MetadataUrlManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConnectionMetadataUrlValidator
extends CompositeValidator {
    private static final MetadataUrlManager METADATA_URL_MANAGER = MgmtFactory.getMetadataUrlManager();
    private ResourceLink metadata = null;
    private boolean ismetadataRequired;

    public ConnectionMetadataUrlValidator(Connection connection) {
        this.initValidator(connection);
    }

    private void initValidator(Connection connection) {
        ConnectionMetadataUrl metadataReload = connection.getMetadataReloadSettings();
        if (metadataReload != null) {
            this.metadata = metadataReload.getMetadataUrlRef();
            boolean browserSsoExists = connection.getBrowserSso() != null;
            boolean hasAttributeQuery = this.hasAttributeQuery(connection);
            boolean bl = this.ismetadataRequired = hasAttributeQuery || browserSsoExists && connection.getBrowserSso().getProtocol() != Protocol.OIDC && !this.isWsFedConnection(connection);
            if (this.ismetadataRequired) {
                this.addValidator((Validator)new ResourceIdValidator(this.metadata, "Metadata URL", ConnectionPaths.getMetadataReloadUrlResource()));
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getMetadataReload(), new Object[]{ConnectionPaths.getMetadataReload()}));
            }
        }
    }

    private boolean hasAttributeQuery(Connection connection) {
        SpConnection spConnection;
        IdpConnection idpConnection;
        return connection instanceof IdpConnection ? (idpConnection = (IdpConnection)connection).getAttributeQuery() != null : connection instanceof SpConnection && (spConnection = (SpConnection)connection).getAttributeQuery() != null;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors() && this.metadata != null) {
            String id = this.metadata.getId();
            if (!this.ismetadataRequired) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getMetadataReload(), new Object[]{ConnectionPaths.getMetadataReload()}));
            } else {
                MetadataUrlCertPair existingMetadataUrl = METADATA_URL_MANAGER.getMetadataUrlPair(id);
                if (existingMetadataUrl == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_id_not_found, ConnectionPaths.getMetadataReloadUrlResourceId(), new Object[]{id}));
                }
            }
        }
        return !this.hasErrors();
    }

    private boolean isWsFedConnection(Connection apiConn) {
        return apiConn.getBrowserSso().getProtocol() == Protocol.WSFED;
    }
}

