/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;
import org.sourceid.saml20.domain.SourceContextType;

public class ContextSourceTypeValidator
extends AbstractValidator {
    private final String attributeName;
    private final String value;
    private final String fieldPath;
    private final Set<SourceContextType> validContextSources;
    private final ContextSourceTypeMsgContext msgContext;

    ContextSourceTypeValidator(String attributeName, String value, Set<SourceContextType> validContextSources, String fieldPath, ContextSourceTypeMsgContext msgContext) {
        this.attributeName = attributeName;
        this.value = value;
        this.validContextSources = validContextSources;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
    }

    public boolean validate() {
        String tempId = "context." + this.value;
        SourceContextType tempType = null;
        try {
            tempType = SourceContextType.getTypeFromId((String)tempId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (tempType == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getUnknownValueKey(), this.fieldPath, new Object[]{this.value, this.attributeName}));
        } else if (!this.validContextSources.contains(tempType)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getValueNotApplicableKey(), this.fieldPath, new Object[]{this.value, this.attributeName}));
        }
        if (tempType == SourceContextType.SIGNED_REQUEST_OBJECT_CLAIMS || tempType == SourceContextType.SAML_AUTHN_REQUEST || tempType == SourceContextType.CHAINED_ATTRIBUTES) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getValueNotApplicableKey(), this.fieldPath, new Object[]{this.value, this.attributeName}));
        }
        return !this.hasErrors();
    }

    public static enum ContextSourceTypeMsgContext {
        ATTR_MAPPING{

            @Override
            public ApiMessageKey getUnknownValueKey() {
                return ApiMessageKey.mapping_source_type_context_unknown_value;
            }

            @Override
            public ApiMessageKey getValueNotApplicableKey() {
                return ApiMessageKey.mapping_source_type_context_value_not_applicable;
            }
        }
        ,
        ISSUANCE_CRITERIA{

            @Override
            public ApiMessageKey getUnknownValueKey() {
                return ApiMessageKey.issuance_criteria_source_type_context_unknown_value;
            }

            @Override
            public ApiMessageKey getValueNotApplicableKey() {
                return ApiMessageKey.issuance_criteria_source_type_context_value_not_applicable;
            }
        };


        public abstract ApiMessageKey getUnknownValueKey();

        public abstract ApiMessageKey getValueNotApplicableKey();
    }
}

