/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.SourceContextType;

public class ContextSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private List<SourceContextType> contextSources = new ArrayList<SourceContextType>();

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), SourceType.CONTEXT);
        HashSet<SourceContextType> validContexts = new HashSet<SourceContextType>();
        validContexts.addAll(this.contextSources);
        return new ContextSourceTypeValidator(attributeName, afv.getValue(), validContexts, attributePath, ContextSourceTypeValidator.ContextSourceTypeMsgContext.ATTR_MAPPING);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), SourceType.CONTEXT);
        HashSet<SourceContextType> validContexts = new HashSet<SourceContextType>();
        validContexts.addAll(this.contextSources);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new ContextSourceTypeValidator(null, icEntry.getAttributeName(), validContexts, attributePath, ContextSourceTypeValidator.ContextSourceTypeMsgContext.ISSUANCE_CRITERIA), icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        HashSet<String> subs = new HashSet<String>();
        for (SourceContextType contextType : this.contextSources) {
            subs.add(contextType.getId());
        }
        return subs;
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }

    public List<SourceContextType> getContextSources() {
        return this.contextSources;
    }

    public void setContextSources(List<SourceContextType> contextSources) {
        this.contextSources = contextSources;
    }
}

