/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.collectsupportdata.CsdNodeType;
import com.pingidentity.admin.api.model.collectsupportdata.CsdSettings;
import com.pingidentity.admin.api.model.fieldpaths.CollectSupportDataPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.CollectSupportDataManager;
import org.sourceid.saml20.domain.mgmt.impl.CsdArchiveInfo;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.util.collectsupportdata.CsdArchiveStatus;

public class CsdSettingsValidator
extends CompositeValidator {
    private static final int FIPS_MODE_MIN_PWD_LENGTH = 14;

    public CsdSettingsValidator(CsdSettings settings, CollectSupportDataManager collectSupportDataManager, NodeIndexRegistry nodeIndexRegistry) {
        IntegerValidator logCountValidator = new IntegerValidator(String.valueOf(settings.getRolledLogCount()), "Rolled Log Count", CollectSupportDataPaths.getRolledLogCountPath(), false, 0, null);
        this.addValidator((Validator)logCountValidator);
        IntegerValidator numHeartbeatSamplesValidator = new IntegerValidator(String.valueOf(settings.getNumHeartbeatSamples()), "Number of Heartbeat Samples", CollectSupportDataPaths.getNumHeartbeatSamplesPath(), false, 0, null);
        this.addValidator((Validator)numHeartbeatSamplesValidator);
        IntegerValidator intervalBetweenHeartbeatSamplesValidator = new IntegerValidator(String.valueOf(settings.getIntervalBetweenHeartbeatSamples()), "Interval Between Heartbeat Samples", CollectSupportDataPaths.getIntervalBetweenHeartbeatSamplesPath(), false, 0, null);
        this.addValidator((Validator)intervalBetweenHeartbeatSamplesValidator);
        IntegerValidator reportCountValidator = new IntegerValidator(String.valueOf(settings.getReportCount()), "Report Count", CollectSupportDataPaths.getReportCountPath(), false, 0, null);
        this.addValidator((Validator)reportCountValidator);
        IntegerValidator reportIntervalValidator = new IntegerValidator(String.valueOf(settings.getReportInterval()), "Report Interval", CollectSupportDataPaths.getReportIntervalPath(), false, 0, null);
        this.addValidator((Validator)reportIntervalValidator);
        this.addValidator((Validator)new NodeTypeToCollectAndNodesToCollectValidator(settings.getNodeTypeToCollect(), settings.getNodesToCollect()));
        this.addValidator((Validator)new NodeTypeToCollectValidator(settings.getNodeTypeToCollect(), nodeIndexRegistry));
        this.addValidator((Validator)new NodesToCollectValidator(settings.getNodesToCollect(), nodeIndexRegistry));
        this.addValidator((Validator)new EncryptArchiveValidator(settings.isEncryptArchive(), settings.getEncryptionPassphrase()));
        this.addValidator((Validator)new TruncateLogsValidator(settings.isTruncateLogs(), settings.getFileHeadCollectionKBSize(), settings.getFileTailCollectionKBSize()));
        this.addValidator((Validator)new InProgressArchivesValidator(collectSupportDataManager, settings.getNodesToCollect(), settings.getNodeTypeToCollect()));
    }

    @Override
    public boolean validate() {
        super.validate();
        return !this.hasErrors();
    }

    private static class InProgressArchivesValidator
    extends AbstractValidator {
        private final CollectSupportDataManager collectSupportDataManager;
        private final List<Integer> nodesToCollect;
        private final CsdNodeType nodeTypeToCollect;

        private InProgressArchivesValidator(CollectSupportDataManager collectSupportDataManager, List<Integer> nodesToCollect, CsdNodeType nodeTypeToCollect) {
            this.collectSupportDataManager = collectSupportDataManager;
            this.nodesToCollect = nodesToCollect;
            this.nodeTypeToCollect = nodeTypeToCollect;
        }

        public boolean validate() {
            List currentArchives = this.collectSupportDataManager.getArchiveStatuses();
            if (currentArchives != null && !currentArchives.isEmpty()) {
                if (this.nodesToCollect != null) {
                    for (Integer nodeId : this.nodesToCollect) {
                        for (CsdArchiveInfo currentArchive : currentArchives) {
                            if (!currentArchive.getNodeIndex().equals(nodeId.toString()) || !currentArchive.getStatus().equals((Object)CsdArchiveStatus.IN_PROGRESS)) continue;
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_collection_already_in_progress, CollectSupportDataPaths.getNodesToCollectPath(), new Object[]{nodeId.toString()}));
                        }
                    }
                }
                if (this.nodeTypeToCollect != null) {
                    EnumSet<Mode> modes = EnumSet.noneOf(Mode.class);
                    switch (this.nodeTypeToCollect) {
                        case STANDALONE: {
                            modes.add(Mode.STANDALONE);
                            break;
                        }
                        case ENGINES: {
                            modes.addAll(EnumSet.of(Mode.CLUSTERED_ENGINE, Mode.CLUSTERED_DUAL));
                            break;
                        }
                        case ADMINS: {
                            modes.addAll(EnumSet.of(Mode.CLUSTERED_CONSOLE, Mode.CLUSTERED_DUAL));
                            break;
                        }
                        case ALL: {
                            modes.addAll(EnumSet.of(Mode.CLUSTERED_ENGINE, Mode.CLUSTERED_CONSOLE, Mode.CLUSTERED_DUAL, Mode.STANDALONE));
                            break;
                        }
                    }
                    if (currentArchives.stream().anyMatch(archive -> modes.contains(archive.getMode()) && archive.getStatus().equals((Object)CsdArchiveStatus.IN_PROGRESS))) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_collection_node_type_already_in_progress, CollectSupportDataPaths.getNodeTypeToCollectPath(), new Object[]{this.nodeTypeToCollect.toString()}));
                    }
                }
            }
            return !this.hasErrors();
        }
    }

    private static class TruncateLogsValidator
    extends CompositeValidator {
        private final boolean truncateLogs;
        private final Long fileHeadCollectionKBSize;
        private final Long fileTailCollectionKBSize;

        private TruncateLogsValidator(boolean truncateLogs, Long fileHeadCollectionKBSize, Long fileTailCollectionKBSize) {
            this.truncateLogs = truncateLogs;
            this.fileHeadCollectionKBSize = fileHeadCollectionKBSize;
            this.fileTailCollectionKBSize = fileTailCollectionKBSize;
        }

        @Override
        public boolean validate() {
            if (this.truncateLogs) {
                if (this.fileHeadCollectionKBSize != null) {
                    IntegerValidator fileHeadCollectionKBSizeValidator = new IntegerValidator(String.valueOf(this.fileHeadCollectionKBSize), "File Head Collection KB Size", "fileHeadCollectionKBSize", false, 0, null);
                    this.addValidator((Validator)fileHeadCollectionKBSizeValidator);
                }
                if (this.fileTailCollectionKBSize != null) {
                    IntegerValidator fileTailCollectionKBSizeValidator = new IntegerValidator(String.valueOf(this.fileTailCollectionKBSize), "File Tail Collection KB Size", "fileTailCollectionKBSize", false, 0, null);
                    this.addValidator((Validator)fileTailCollectionKBSizeValidator);
                }
                if (this.fileTailCollectionKBSize == null && this.fileHeadCollectionKBSize == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_file_tail_or_head_collection_required, CollectSupportDataPaths.getTruncateLogsPath()));
                }
            } else {
                if (this.fileHeadCollectionKBSize != null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_file_tail_or_head_collection_not_required, CollectSupportDataPaths.getFileHeadCollectionKBSizePath()));
                }
                if (this.fileTailCollectionKBSize != null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_file_tail_or_head_collection_not_required, CollectSupportDataPaths.getFileTailCollectionKBSizePath()));
                }
            }
            super.validate();
            return !this.hasErrors();
        }
    }

    private static class EncryptArchiveValidator
    extends AbstractValidator {
        private final boolean encryptArchive;
        private final String encryptionPassphrase;

        private EncryptArchiveValidator(boolean encryptArchive, String encryptionPassphrase) {
            this.encryptArchive = encryptArchive;
            this.encryptionPassphrase = encryptionPassphrase;
        }

        public boolean validate() {
            if (this.encryptArchive) {
                if (StringUtils.isEmpty((String)this.encryptionPassphrase)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_encryption_passphrase_required, CollectSupportDataPaths.getEncryptionPassphrasePath()));
                } else if (PropertyInfo.isBCFIPSMode() && this.encryptionPassphrase.length() < 14) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_bcfips_encryption_passphrase_min_length_required, CollectSupportDataPaths.getEncryptionPassphrasePath(), new Object[]{14}));
                }
            } else if (StringUtils.isNotEmpty((String)this.encryptionPassphrase)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_encryption_passphrase_not_required, CollectSupportDataPaths.getEncryptArchivePath()));
            }
            return !this.hasErrors();
        }
    }

    private static class NodesToCollectValidator
    extends AbstractValidator {
        private final List<Integer> nodesToCollect;
        private final NodeIndexRegistry nodeIndexRegistry;

        private NodesToCollectValidator(List<Integer> nodesToCollect, NodeIndexRegistry nodeIndexRegistry) {
            this.nodesToCollect = nodesToCollect;
            this.nodeIndexRegistry = nodeIndexRegistry;
        }

        public boolean validate() {
            if (this.nodesToCollect != null) {
                for (Integer nodeId : this.nodesToCollect) {
                    if (this.nodeIndexRegistry.getAddress(nodeId.intValue()) != null) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_invalid_node_id, CollectSupportDataPaths.getNodesToCollectPath(), new Object[]{nodeId}));
                }
            }
            return !this.hasErrors();
        }
    }

    private static class NodeTypeToCollectValidator
    extends AbstractValidator {
        private final CsdNodeType nodeTypeToCollect;
        private final NodeIndexRegistry nodeIndexRegistry;

        private NodeTypeToCollectValidator(CsdNodeType nodeTypeToCollect, NodeIndexRegistry nodeIndexRegistry) {
            this.nodeTypeToCollect = nodeTypeToCollect;
            this.nodeIndexRegistry = nodeIndexRegistry;
        }

        public boolean validate() {
            if (this.nodeTypeToCollect != null) {
                List nodesToCollect;
                switch (this.nodeTypeToCollect) {
                    case STANDALONE: {
                        nodesToCollect = this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.STANDALONE)).map(Node::getIndex).collect(Collectors.toList());
                        break;
                    }
                    case ENGINES: {
                        nodesToCollect = this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.CLUSTERED_ENGINE)).map(Node::getIndex).collect(Collectors.toList());
                        break;
                    }
                    case ADMINS: {
                        nodesToCollect = this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.CLUSTERED_CONSOLE)).map(Node::getIndex).collect(Collectors.toList());
                        break;
                    }
                    case ALL: {
                        nodesToCollect = this.nodeIndexRegistry.getNodes().stream().map(Node::getIndex).collect(Collectors.toList());
                        break;
                    }
                    default: {
                        nodesToCollect = Collections.EMPTY_LIST;
                    }
                }
                if (nodesToCollect.isEmpty()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_no_nodes_of_type, CollectSupportDataPaths.getNodeTypeToCollectPath(), new Object[]{this.nodeTypeToCollect.toString()}));
                }
            }
            return !this.hasErrors();
        }
    }

    private static class NodeTypeToCollectAndNodesToCollectValidator
    extends AbstractValidator {
        private final List<Integer> nodesToCollect;
        private final CsdNodeType nodeTypeToCollect;

        private NodeTypeToCollectAndNodesToCollectValidator(CsdNodeType nodeTypeToCollect, List<Integer> nodesToCollect) {
            this.nodeTypeToCollect = nodeTypeToCollect;
            this.nodesToCollect = nodesToCollect;
        }

        public boolean validate() {
            if (this.nodesToCollect != null && this.nodeTypeToCollect != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_node_type_to_collect_not_required, CollectSupportDataPaths.getNodeTypeToCollectPath()));
            } else if ((this.nodesToCollect == null || this.nodesToCollect.isEmpty()) && this.nodeTypeToCollect == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csd_node_to_collect_required, CollectSupportDataPaths.getNodesToCollectPath()));
            }
            return !this.hasErrors();
        }
    }
}

