/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pingcommons.crypto.B64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class CsrResponseValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CsrResponseValidator.class);
    private InputStream csrStream;
    private String fieldPath;
    private PkCert pkCert;
    private PkCert newPkCert;

    public CsrResponseValidator(String csrString, PkCert pkCert, String fieldPath) {
        this.pkCert = pkCert;
        this.fieldPath = fieldPath;
        if (csrString.startsWith("-----BEGIN")) {
            try {
                this.csrStream = new ByteArrayInputStream(csrString.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unexpected error encoding string as UTF-8", e);
            }
        } else {
            this.csrStream = new ByteArrayInputStream(B64.decodeToBytes((String)csrString));
        }
    }

    public CsrResponseValidator(InputStream csrStream, PkCert pkCert, String fieldPath) {
        this.csrStream = csrStream;
        this.fieldPath = fieldPath;
        this.pkCert = pkCert;
    }

    public PkCert getNewPkCert() {
        return this.newPkCert;
    }

    public boolean validate() {
        try {
            TrustedCAsManager trustedCAsMgr = MgmtFactory.getTrustedCAsManager();
            Set certs = trustedCAsMgr.getTrustedCaX509s();
            this.newPkCert = this.pkCert.importCSRReply(this.csrStream, (Collection)certs);
        }
        catch (GeneralSecurityException g) {
            if (g instanceof CertPathValidatorException) {
                if (g.getCause() instanceof CertificateNotYetValidException) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csr_response_cert_not_yet_valid, this.fieldPath));
                } else if (g.getCause() instanceof CertificateExpiredException) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csr_response_cert_expired, this.fieldPath));
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csr_response_cannot_validate_trust_chain, this.fieldPath));
                }
            } else if (g instanceof CertificateException) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csr_response_invalid, this.fieldPath));
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csr_response_mismatched_keys, this.fieldPath));
            }
            log.debug((Object)("There was a problem importing the CSR Response: " + g));
        }
        catch (IOException io) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csr_response_unexpected_error, this.fieldPath));
            log.debug((Object)("There was a problem importing the CSR Response: " + io));
        }
        catch (IllegalArgumentException e) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.csr_response_invalid, this.fieldPath));
        }
        return !this.hasErrors();
    }
}

