/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.CustomDataStore;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class CustomDataStoreValidator
extends PluginInstanceValidator {
    private final DataSourceManager dataSourceManager;

    public CustomDataStoreValidator(CustomDataStore dataStore, PluginManager<?, ?> manager, boolean isCreate, PluginEnum pluginType, DataSourceManager dataSourceManager, ValidatorContext validatorContext) {
        super(dataStore, manager, isCreate, pluginType, validatorContext);
        this.dataSourceManager = dataSourceManager;
        if (isCreate) {
            this.addValidator((Validator)new IdValidator(this.apiInstance.getId(), true, false, 0, 53, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getId())));
        }
    }

    @Override
    protected void validateId() {
        if (this.isCreate && this.apiInstance.getId() != null && this.pluginManager.isDuplicateId(this.apiInstance.getId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_id_in_use, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getId())));
        }
    }

    @Override
    protected void validateName() {
        if (StringUtils.isBlank((String)this.apiInstance.getName())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_name_required, PluginInstancePaths.getName()));
        } else {
            boolean hasError = false;
            for (ConfigurablePluginInstance instance : this.pluginManager.getInstances()) {
                String name = null;
                name = instance instanceof CustomDataSource ? ((CustomDataSource)instance).getDescription() : instance.getName();
                if (!name.equals(this.apiInstance.getName()) || instance.getId().equals(this.apiInstance.getId())) continue;
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_name_in_use, PluginInstancePaths.getName()));
                hasError = true;
                break;
            }
            if (!hasError) {
                Collection allDataSources = this.dataSourceManager.getAllDataSources();
                for (DataSource dataSource : allDataSources) {
                    if (!StringUtils.isNotBlank((String)this.apiInstance.getName()) || !this.apiInstance.getName().equals(dataSource.getDsName())) continue;
                    this.appendError(this.errorFactory.create(ApiMessageKey.plugin_name_in_use, PluginInstancePaths.getName()));
                    break;
                }
            }
        }
    }
}

