/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagConfig;

public abstract class DataSourceTagConfigValidator<TagConfig extends DataSourceTagConfig>
extends CompositeValidator {
    List<TagConfig> tagConfigList;
    private String tagPath;
    private boolean validateDuplicateTags = true;
    protected boolean validateDuplicateDataStoreIdentifier = true;

    DataSourceTagConfigValidator(List<TagConfig> tagConfigList, String tagPath) {
        this.tagConfigList = tagConfigList;
        this.tagPath = tagPath;
    }

    public void setValidateDuplicateTags(boolean validateDuplicateTags) {
        this.validateDuplicateTags = validateDuplicateTags;
    }

    public void setValidateDuplicateDataStoreIdentifier(boolean validateDuplicateDataStoreIdentifier) {
        this.validateDuplicateDataStoreIdentifier = validateDuplicateDataStoreIdentifier;
    }

    private Set<String> hasDuplicateTags() {
        HashSet<String> currentTags = new HashSet<String>();
        HashSet<String> duplicateTags = new HashSet<String>();
        if (this.tagConfigList != null) {
            for (DataSourceTagConfig dataSourceTag : this.tagConfigList) {
                String[] tagsArray = this.splitTags(dataSourceTag.getTags());
                if (tagsArray == null) continue;
                for (String tag : tagsArray) {
                    if (currentTags.contains(tag)) {
                        duplicateTags.add(tag);
                        continue;
                    }
                    currentTags.add(tag);
                }
            }
        }
        return duplicateTags;
    }

    abstract Set<String> hasDuplicateDataStoreIdentifier();

    abstract void validateDefaultSet();

    void validateNoMultipleEmptyTag() {
        if (this.tagConfigList.stream().filter(tagConfig -> tagConfig.getTagsHashSet().isEmpty()).count() > 1L) {
            this.appendMultipleEmptyTagError();
        }
    }

    abstract void appendMultipleEmptyTagError();

    @Override
    public boolean validate() {
        Set<String> duplicateTags;
        super.validate();
        if (this.validateDuplicateTags && !(duplicateTags = this.hasDuplicateTags()).isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_duplicate_tag, this.tagPath, new Object[]{"'" + StringUtils.join(duplicateTags, (String)"', '") + "'"}));
        }
        this.validateDefaultSet();
        this.validateNoMultipleEmptyTag();
        return !this.hasErrors();
    }

    private String[] splitTags(String tags) {
        return StringUtils.split((String)tags, null);
    }
}

