/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.DataStorePaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class DataStoreBaseValidator
extends CompositeValidator {
    private final DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
    protected boolean isCreate;
    protected String name;
    protected String id;
    protected String encryptedPassword;

    @Override
    public boolean validate() {
        if (this.isCreate) {
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 53, DataStorePaths.getId()));
        }
        super.validate();
        this.validateNameAndId();
        if (this.requirePasswordCheck()) {
            this.validateEncryptedPassword();
        }
        return !this.hasErrors();
    }

    public abstract boolean requirePasswordCheck();

    private void validateNameAndId() {
        block3: {
            Collection allDataSources;
            block4: {
                allDataSources = this.dataSourceManager.getAllDataSources();
                if (this.name == null) break block3;
                if (!this.isCreate) break block4;
                for (DataSource source : allDataSources) {
                    if (this.id != null && this.id.equals(source.getId())) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_duplicate_id, DataStorePaths.getId()));
                    }
                    if (!this.name.equals(source.getDsName()) && (!DataSource.DSType.Other.equals((Object)source.getDSType()) || !this.name.equals(source.getDescription()))) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_duplicate_name, DataStorePaths.getName()));
                }
                break block3;
            }
            if (this.id == null) break block3;
            for (DataSource source : allDataSources) {
                if (this.id.equals(source.getId()) || !this.name.equals(source.getDsName()) && (!DataSource.DSType.Other.equals((Object)source.getDSType()) || !this.name.equals(source.getDescription()))) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_duplicate_name, DataStorePaths.getName()));
                break;
            }
        }
    }

    private void validateEncryptedPassword() {
        if (StringUtils.isNotEmpty((String)this.encryptedPassword) && !SecretReferenceUtil.isSecretReference((String)this.encryptedPassword)) {
            try {
                if (FieldObfuscator.REAL.deobfuscate(this.encryptedPassword) == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_invalid_encrypted_password, DataStorePaths.getEncryptedPassword()));
                }
            }
            catch (ObfuscationException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_invalid_encrypted_password, DataStorePaths.getEncryptedPassword()));
            }
        }
    }
}

