/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.sso.idp.DataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.JdbcDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.LdapDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.SqlMethod;
import com.pingidentity.admin.api.model.sso.idp.StoredProcedure;
import com.pingidentity.admin.api.model.sso.idp.Table;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ExpectedAttributesValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;

public class DataStoreRepositoryAttributeValidator {
    private DataStoreRepositoryAttributeValidator() {
    }

    public static Validator getInstance(DataStoreRepository dataStoreRepository, DataSourceManager dsManager) {
        switch (dataStoreRepository.getType()) {
            case LDAP: {
                LdapDataStoreRepository ldapDataStoreRepository = (LdapDataStoreRepository)dataStoreRepository;
                return new LdapDataStoreRepositoryAttributeValidator(ldapDataStoreRepository, dsManager);
            }
            case JDBC: {
                JdbcDataStoreRepository jdbcDataStoreRepository = (JdbcDataStoreRepository)dataStoreRepository;
                return new JdbcDataStoreRepositoryAttributeValidator(jdbcDataStoreRepository, dsManager);
            }
        }
        return null;
    }

    private static class JdbcDataStoreRepositoryAttributeValidator
    extends CompositeValidator {
        private final JdbcDataStoreRepository jdbcDataStoreRepository;
        private final DataSourceManager dsManager;

        private JdbcDataStoreRepositoryAttributeValidator(JdbcDataStoreRepository jdbcDataStoreRepository, DataSourceManager dsManager) {
            this.jdbcDataStoreRepository = jdbcDataStoreRepository;
            this.dsManager = dsManager;
            this.initialize();
        }

        private void initialize() {
            String dsId = this.jdbcDataStoreRepository.getDataStoreRef().getId();
            JdbcDataSource jdbcDataSource = this.dsManager.getJdbcDataSource(dsId);
            ArrayList<String> expectedAttributes = new ArrayList<String>();
            if (jdbcDataSource != null) {
                SqlMethod sqlMethod = this.jdbcDataStoreRepository.getSqlMethod();
                if (sqlMethod != null) {
                    List allColsWithMetadata;
                    if (sqlMethod.getTable() != null) {
                        Table table = sqlMethod.getTable();
                        allColsWithMetadata = jdbcDataSource.getUnsortedColumnsWithMetadata(table.getSchema(), table.getTableName());
                        for (ResultInfo resultInfo : allColsWithMetadata) {
                            expectedAttributes.add(resultInfo.getColumnName());
                        }
                    } else if (sqlMethod.getStoredProcedure() != null) {
                        StoredProcedure storedProcedure = sqlMethod.getStoredProcedure();
                        allColsWithMetadata = jdbcDataSource.getUnsortedStoredProcedureColumnsWithMetadata(storedProcedure.getSchema(), storedProcedure.getStoredProcedure());
                        for (ResultInfo resultInfo : allColsWithMetadata) {
                            expectedAttributes.add(resultInfo.getColumnName());
                        }
                    }
                }
                int dsMappingKeyIndex = 0;
                Map<String, AttributeFulfillmentValue> repositoryMapping = this.jdbcDataStoreRepository.getJitRepositoryAttributeMapping();
                if (repositoryMapping == null || repositoryMapping.isEmpty()) {
                    this.addValidator((Validator)new NotNullValidator(repositoryMapping, "User Repository Mapping", ConnectionPaths.getJitProvisioningAttributeMapping()));
                } else {
                    for (String repositoryAttributeName : repositoryMapping.keySet()) {
                        this.addValidator((Validator)new ExpectedAttributesValidator(repositoryAttributeName, expectedAttributes, ApiMessageKey.jit_provisioning_user_repository_mapping_name_unknown_jdbc_attribute_name, ConnectionPaths.getJitProvisioningAttributeMapping(dsMappingKeyIndex++), "name"));
                    }
                }
            }
        }
    }

    private static class LdapDataStoreRepositoryAttributeValidator
    extends CompositeValidator {
        private final LdapDataStoreRepository ldapDataStoreRepository;
        private final DataSourceManager dsManager;

        private LdapDataStoreRepositoryAttributeValidator(LdapDataStoreRepository ldapDataStoreRepository, DataSourceManager dsManager) {
            this.ldapDataStoreRepository = ldapDataStoreRepository;
            this.dsManager = dsManager;
            this.initialize();
        }

        private void initialize() {
            String dsId = this.ldapDataStoreRepository.getDataStoreRef().getId();
            LdapDataSource ldapDataSource = this.dsManager.getLdapDataSource(dsId);
            ArrayList<String> expectedAttributes = new ArrayList<String>();
            if (ldapDataSource != null) {
                expectedAttributes.add("Subject DN");
                expectedAttributes.addAll(ldapDataSource.getLDAPAttributeNameList());
            }
            int dsMappingKeyIndex = 0;
            Map<String, AttributeFulfillmentValue> repositoryMapping = this.ldapDataStoreRepository.getJitRepositoryAttributeMapping();
            if (repositoryMapping == null || repositoryMapping.isEmpty()) {
                this.addValidator((Validator)new NotNullValidator(repositoryMapping, "User Repository Mapping", ConnectionPaths.getJitProvisioningAttributeMapping()));
            } else {
                ArrayList<String> repositoryAttributeNames = new ArrayList<String>(repositoryMapping.keySet());
                for (String repositoryAttributeName : repositoryAttributeNames) {
                    this.addValidator((Validator)new ExpectedAttributesValidator(repositoryAttributeName, expectedAttributes, ApiMessageKey.jit_provisioning_user_repository_mapping_name_unknown_ldap_attribute_name, ConnectionPaths.getJitProvisioningAttributeMapping(dsMappingKeyIndex++), "name"));
                }
            }
        }
    }
}

