/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.sso.idp.EventTriggerType;
import com.pingidentity.admin.api.model.sso.idp.JdbcDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.JitProvisioning;
import com.pingidentity.admin.api.model.sso.idp.LdapDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.SqlMethod;
import com.pingidentity.admin.api.model.sso.idp.StoredProcedure;
import com.pingidentity.admin.api.model.sso.idp.Table;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.DataStoreRepositoryAttributeValidator;
import com.pingidentity.admin.api.validator.JdbcStoredProcedureValidator;
import com.pingidentity.admin.api.validator.JdbcTableValidator;
import com.pingidentity.admin.api.validator.JdbcUniqueIdColumnValidator;
import com.pingidentity.admin.api.validator.LdapNameValidator;
import com.pingidentity.admin.api.validator.LdapSearchFilterValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;

public class DataStoreRepositoryValidator {
    private DataStoreRepositoryValidator() {
    }

    public static Validator getInstance(JitProvisioning jitProvisioning, Collection<String> availableVars, DataSourceManager dsManager, ValidatorContext context) {
        switch (jitProvisioning.getUserRepository().getType()) {
            case LDAP: {
                LdapDataStoreRepository ldapDataStoreRepository = (LdapDataStoreRepository)jitProvisioning.getUserRepository();
                return new LdapDataStoreRepositoryValidator(ldapDataStoreRepository, availableVars, dsManager, context);
            }
            case JDBC: {
                JdbcDataStoreRepository jdbcDataStoreRepository = (JdbcDataStoreRepository)jitProvisioning.getUserRepository();
                return new JdbcDataStoreRepositoryValidator(jdbcDataStoreRepository, jitProvisioning.getEventTrigger(), dsManager, context);
            }
        }
        return null;
    }

    private static class JdbcDataStoreRepositoryValidator
    extends CompositeValidator {
        private final JdbcDataStoreRepository jdbcDataStoreRepository;
        private final EventTriggerType eventTriggerType;
        private final ValidatorContext context;
        private final DataSourceManager dsManager;

        private JdbcDataStoreRepositoryValidator(JdbcDataStoreRepository jdbcDataStoreRepository, EventTriggerType eventTriggerType, DataSourceManager dsManager, ValidatorContext context) {
            this.jdbcDataStoreRepository = jdbcDataStoreRepository;
            this.eventTriggerType = eventTriggerType;
            this.dsManager = dsManager;
            this.context = context;
            this.addValidator((Validator)new ResourceIdValidator(jdbcDataStoreRepository.getDataStoreRef(), "Data Store reference id", ConnectionPaths.getJitProvisioningDataStoreRef()));
        }

        @Override
        public boolean validate() {
            Validator validator;
            String dataStoreId;
            boolean isValid = super.validate();
            if (isValid) {
                dataStoreId = this.jdbcDataStoreRepository.getDataStoreRef().getId();
                JdbcDataSource jdbcDataSource = this.dsManager.getJdbcDataSource(dataStoreId);
                String dataStoreRefPath = ConnectionPaths.getJitProvisioningDataStoreRef();
                if (jdbcDataSource == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_not_found, dataStoreRefPath, new Object[]{dataStoreId}));
                    isValid = false;
                } else {
                    boolean isSupported = jdbcDataSource.isSqlServerDriver();
                    if (!isSupported) {
                        String driverClass = jdbcDataSource.getDriverClass();
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_unsupported_jdbc_data_store, dataStoreRefPath, new Object[]{driverClass}));
                        isValid = false;
                    }
                }
            }
            if (isValid) {
                dataStoreId = this.jdbcDataStoreRepository.getDataStoreRef().getId();
                JdbcDataSource jdbcDs = this.dsManager.getJdbcDataSource(dataStoreId);
                SqlMethod sqlMethod = this.jdbcDataStoreRepository.getSqlMethod();
                if (sqlMethod != null) {
                    List allColsWithMetadata;
                    if (sqlMethod.getTable() != null) {
                        Table table = sqlMethod.getTable();
                        isValid = this.runValidator((Validator)new NotNullValidator(table.getSchema(), "Schema", ConnectionPaths.getJitProvisioningTable()));
                        if (isValid &= this.runValidator((Validator)new NotNullValidator(table.getTableName(), "Table", ConnectionPaths.getJitProvisioningTable()))) {
                            allColsWithMetadata = jdbcDs.getUnsortedColumnsWithMetadata(table.getSchema(), table.getTableName());
                            JdbcTableValidator tableValidator = new JdbcTableValidator(table.getSchema(), table.getTableName(), allColsWithMetadata, false, ConnectionPaths.getJitProvisioningSqlMethod());
                            isValid = this.runValidator((Validator)tableValidator);
                            ArrayList<String> validSubstitutionVars = new ArrayList<String>();
                            for (ResultInfo resultInfo : allColsWithMetadata) {
                                validSubstitutionVars.add(resultInfo.getColumnName());
                            }
                            JdbcUniqueIdColumnValidator uniqueIdColumnValidator = new JdbcUniqueIdColumnValidator(table.getUniqueIdColumn(), validSubstitutionVars, "sql table column", ConnectionPaths.getJitProvisioningTableUniqueIdColumn(), this.isBypassExternalValidation());
                            isValid &= this.runValidator((Validator)uniqueIdColumnValidator);
                        }
                    } else if (sqlMethod.getStoredProcedure() != null) {
                        StoredProcedure storedProcedure = sqlMethod.getStoredProcedure();
                        isValid = this.runValidator((Validator)new NotNullValidator(storedProcedure.getSchema(), "Schema", ConnectionPaths.getJitProvisioningStoredProcedure()));
                        if (isValid &= this.runValidator((Validator)new NotNullValidator(storedProcedure.getStoredProcedure(), "Stored Procedure", ConnectionPaths.getJitProvisioningStoredProcedure()))) {
                            allColsWithMetadata = jdbcDs.getUnsortedStoredProcedureColumnsWithMetadata(storedProcedure.getSchema(), storedProcedure.getStoredProcedure());
                            JdbcStoredProcedureValidator storedProcedureValidator = new JdbcStoredProcedureValidator(storedProcedure.getSchema(), storedProcedure.getStoredProcedure(), allColsWithMetadata, jdbcDs, false, ConnectionPaths.getJitProvisioningStoredProcedure());
                            isValid = this.runValidator((Validator)storedProcedureValidator);
                        }
                        if (isValid && this.eventTriggerType != null && !EventTriggerType.ALL_SAML_ASSERTIONS.equals((Object)this.eventTriggerType)) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_sql_method_stored_procedure_invalid_event_trigger, ConnectionPaths.getJitProvisioningEventTrigger()));
                            isValid = false;
                        }
                    } else {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_sql_method_not_found, ConnectionPaths.getJitProvisioningSqlMethod()));
                    }
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_sql_method_not_found, ConnectionPaths.getJitProvisioningSqlMethod()));
                }
            }
            if (isValid && !this.isBypassExternalValidation() && (validator = DataStoreRepositoryAttributeValidator.getInstance(this.jdbcDataStoreRepository, this.dsManager)) != null) {
                isValid = this.runValidator(validator);
            }
            return isValid;
        }

        private boolean runValidator(Validator validator) {
            boolean result = validator.validate();
            if (!result) {
                this.appendErrors(validator.getErrors());
            }
            return result;
        }

        private boolean isBypassExternalValidation() {
            return this.context != null && this.context.isBypassExternalValidation();
        }
    }

    private static class LdapDataStoreRepositoryValidator
    extends CompositeValidator {
        private final LdapDataStoreRepository ldapDataStoreRepository;
        private final Collection<String> availableVars;
        private final ValidatorContext context;
        private final DataSourceManager dsManager;

        private LdapDataStoreRepositoryValidator(LdapDataStoreRepository ldapDataStoreRepository, Collection<String> availableVars, DataSourceManager dsManager, ValidatorContext context) {
            this.ldapDataStoreRepository = ldapDataStoreRepository;
            this.availableVars = availableVars;
            this.context = context;
            this.dsManager = dsManager;
            this.addValidator((Validator)new ResourceIdValidator(ldapDataStoreRepository.getDataStoreRef(), "Data Store reference id", ConnectionPaths.getJitProvisioningDataStoreRef()));
        }

        @Override
        public boolean validate() {
            Validator validator;
            boolean isValid = super.validate();
            if (isValid) {
                String dataStoreId = this.ldapDataStoreRepository.getDataStoreRef().getId();
                LdapDataSource ldapDataSource = this.dsManager.getLdapDataSource(dataStoreId);
                String dataStoreRefPath = ConnectionPaths.getJitProvisioningDataStoreRef();
                if (ldapDataSource == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_not_found, dataStoreRefPath, new Object[]{dataStoreId}));
                    isValid = false;
                }
            }
            if (isValid && StringUtils.isNotBlank((String)this.ldapDataStoreRepository.getBaseDn())) {
                LdapNameValidator baseDnValidator = new LdapNameValidator(this.ldapDataStoreRepository.getBaseDn(), this.availableVars, ApiMessageKey.ldap_attribute_source_base_dn_malformed, ApiMessageKey.ldap_attribute_source_base_dn_var_not_found, ConnectionPaths.getJitProvisioningBaseDn());
                isValid = this.runValidator((Validator)baseDnValidator);
            }
            if (isValid) {
                LdapSearchFilterValidator uniqueUserIdFilterValidator = new LdapSearchFilterValidator(this.ldapDataStoreRepository.getUniqueUserIdFilter(), this.availableVars, "assertion", ApiMessageKey.ldap_attribute_source_search_filter_required, ApiMessageKey.ldap_attribute_source_search_filter_var_not_found, ConnectionPaths.getJitProvisioningUniqueUserIdFilter(), "ONELEVEL_SCOPE", this.isBypassExternalValidation());
                isValid = this.runValidator((Validator)uniqueUserIdFilterValidator);
            }
            if (isValid && !this.isBypassExternalValidation() && (validator = DataStoreRepositoryAttributeValidator.getInstance(this.ldapDataStoreRepository, this.dsManager)) != null) {
                isValid = this.runValidator(validator);
            }
            return isValid;
        }

        private boolean runValidator(Validator validator) {
            boolean result = validator.validate();
            if (!result) {
                this.appendErrors(validator.getErrors());
            }
            return result;
        }

        private boolean isBypassExternalValidation() {
            return this.context != null && this.context.isBypassExternalValidation();
        }
    }
}

