/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.io.IOException;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import sun.security.x509.X500Name;

public class DnValidator
extends AbstractValidator {
    private String distinguishedName;
    private ApiMessageKey invalidDnErrorId;
    private ApiMessageKey notATrustAnchorErrorId;
    private String fieldPath;
    private boolean mustBeTrustAnchor = false;
    private TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();

    public DnValidator(String distinguishedName, String fieldPath, ApiMessageKey invalidDnErrorId) {
        this.distinguishedName = distinguishedName;
        this.invalidDnErrorId = invalidDnErrorId;
        this.fieldPath = fieldPath;
    }

    public DnValidator(String distinguishedName, String fieldPath, ApiMessageKey invalidDnErrorId, boolean mustBeTrustAnchor, ApiMessageKey notATrustAnchorErrorId) {
        this(distinguishedName, fieldPath, invalidDnErrorId);
        this.mustBeTrustAnchor = mustBeTrustAnchor;
        this.notATrustAnchorErrorId = notATrustAnchorErrorId;
    }

    public DnValidator(String distinguishedName, String fieldPath, ApiMessageKey invalidDnErrorId, boolean mustBeTrustAnchor, ApiMessageKey notATrustAnchorErrorId, TrustedCAsManager trustedCAsManager) {
        this(distinguishedName, fieldPath, invalidDnErrorId, mustBeTrustAnchor, notATrustAnchorErrorId);
        this.trustedCAsManager = trustedCAsManager;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.distinguishedName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.invalidDnErrorId, this.fieldPath));
            return false;
        }
        try {
            new X500Name(this.distinguishedName);
        }
        catch (IOException io) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.invalidDnErrorId, this.fieldPath));
            return false;
        }
        if (this.mustBeTrustAnchor && this.trustedCAsManager.getTrustAnchorsByDN(new X500Principal(this.distinguishedName)).isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.notATrustAnchorErrorId, this.fieldPath));
            return false;
        }
        return true;
    }
}

