/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Set;

public class DsSourceTypeValidator
extends AbstractValidator {
    private final String attributeName;
    private final String value;
    private final String attrSourceDatastoreRefId;
    private final String fieldPath;
    private final String sourceId;
    private final SourceType sourceType;
    private final Set<String> dsAttributes;
    private final DsSourceTypeMsgContext msgContext;
    private ValidatorContext context;

    DsSourceTypeValidator(String attributeName, String value, String attrSourceDatastoreRefId, SourceTypeIdKey sourceKey, Set<String> dsAttributes, String fieldPath, DsSourceTypeMsgContext msgContext, ValidatorContext context) {
        this.attributeName = attributeName;
        this.value = value;
        this.attrSourceDatastoreRefId = attrSourceDatastoreRefId;
        this.sourceType = sourceKey.getType();
        this.sourceId = sourceKey.getId();
        this.dsAttributes = dsAttributes;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
        this.context = context;
    }

    private boolean isBypassExternalValidation() {
        return this.context != null && this.context.isBypassExternalValidation();
    }

    public boolean validate() {
        if (this.isBypassExternalValidation()) {
            return true;
        }
        boolean isValid = this.dsAttributes.contains(this.value);
        if (!isValid && (SourceType.LDAP_DATA_STORE.equals((Object)this.sourceType) || SourceType.PING_ONE_LDAP_GATEWAY_DATA_STORE.equals((Object)this.sourceType))) {
            isValid = this.dsAttributes.stream().anyMatch(attribute -> this.value.startsWith(attribute + ";"));
        }
        if (!isValid) {
            Object sourceDesc = this.sourceType.name();
            if (this.sourceId != null) {
                sourceDesc = (String)sourceDesc + " (" + this.sourceId + ")";
            } else if (this.attrSourceDatastoreRefId != null) {
                sourceDesc = (String)sourceDesc + " (" + this.attrSourceDatastoreRefId + ")";
            }
            this.appendError(ValidationErrorFactory.getInstance().create(this.msgContext.getInvalidAttributeKey(), this.fieldPath, new Object[]{sourceDesc, this.value, this.attributeName}));
            return false;
        }
        return true;
    }

    public static enum DsSourceTypeMsgContext {
        ATTR_MAPPING{

            @Override
            public ApiMessageKey getInvalidAttributeKey() {
                return ApiMessageKey.mapping_source_type_attribute_source_invalid_attribute;
            }
        }
        ,
        ISSUANCE_CRITERIA{

            @Override
            public ApiMessageKey getInvalidAttributeKey() {
                return ApiMessageKey.issuance_criteria_source_type_attribute_source_invalid_attribute;
            }
        };


        public abstract ApiMessageKey getInvalidAttributeKey();
    }
}

