/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.OAuthClientValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DynamicClientRegistrationValidator
extends OAuthClientValidator {
    private static final ClientManager clientManager = MgmtFactory.getClientManager();
    private final ClientSetting clientSetting;

    public DynamicClientRegistrationValidator(Client client, ClientSetting clientSetting, boolean isUpdate) {
        super(client, !isUpdate ? id -> {
            Client client1 = clientManager.getClient(id);
            return client1 == null;
        } : id -> true);
        this.setStateUIValidation(true);
        this.clientSetting = clientSetting;
        this.setUseDefaultIdTokenSigningAlgo(StringUtils.isNotBlank((String)client.getIdTokenSigningAlgorithm()));
        this.setValidateSectorIdentifierUri(true);
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.client.getRestrictedScopes().size() > 0) {
            HashSet allowedScopesToRequest = new HashSet(this.clientSetting.getAllowedExclusiveScopes());
            allowedScopesToRequest.addAll(new Scope(this.clientSetting.getAllowedExclusiveScopes()).expanded().getScopeSet());
            if (this.clientSetting.isRestrictCommonScopes()) {
                allowedScopesToRequest.addAll(this.clientSetting.getRestrictedCommonScopes());
            } else {
                allowedScopesToRequest.addAll(ScopeUtil.getScopeAndGroupNames());
            }
            Scope allowedScopes = new Scope(allowedScopesToRequest);
            List requestedRestrictedScopeSet = this.client.getRestrictedScopes();
            requestedRestrictedScopeSet.removeIf(scope -> !allowedScopes.getScopeSet().contains(scope));
            if (requestedRestrictedScopeSet.size() == 0 && this.client.getExclusiveScopes().size() == 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_registration_invalid_scope, null));
            }
            if (requestedRestrictedScopeSet.size() > 0) {
                Scope requestedScope = new Scope(new HashSet(requestedRestrictedScopeSet));
                if (this.client.getRestrictedScopes().size() > 0 && !requestedScope.isEqualOrLesserThan(allowedScopes)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_registration_invalid_scope, null));
                }
            }
        } else if (this.clientSetting.isRestrictCommonScopes()) {
            this.client.setRestrictScopes(true);
            this.client.setRestrictedScopes(new ArrayList(this.clientSetting.getRestrictedCommonScopes()));
        }
        if (this.client.getGrantTypes() != null && this.client.getGrantTypes().contains("urn:pingidentity.com:oauth2:grant_type:validate_bearer")) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_registration_grant_not_supported, null, new Object[]{"urn:pingidentity.com:oauth2:grant_type:validate_bearer"}));
        }
        return !this.hasErrors();
    }

    @Override
    public boolean isReversibleSecretInvalid(Client client) {
        return false;
    }
}

