/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.EmailServerSettingsPaths;
import com.pingidentity.admin.api.model.systemsettings.EmailServerSettings;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.EmailValidator;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class EmailServerSettingsValidator
extends CompositeValidator {
    private String sourceAddr;
    private String emailServer;
    private String port;
    private String sslPort;
    private String timeout;
    private String username;
    private String password;
    private String encryptedPassword;
    private boolean useSSL;
    private String pathPrefix;
    private String retryAttempts;
    private String retryDelay;
    private boolean skipValidateEmailServer;

    private EmailServerSettingsValidator(Builder builder) {
        this.sourceAddr = builder.sourceAddr;
        this.emailServer = builder.emailServer;
        this.port = builder.port;
        this.sslPort = builder.sslPort;
        this.timeout = builder.timeout;
        this.username = builder.username;
        this.password = builder.password;
        this.encryptedPassword = builder.encryptedPassword;
        this.useSSL = builder.useSSL;
        this.pathPrefix = !StringUtils.isBlank((String)builder.pathPrefix) ? builder.pathPrefix + "." : "";
        this.retryAttempts = builder.retryAttempts;
        this.retryDelay = builder.retryDelay;
        this.skipValidateEmailServer = builder.skipValidateEmailServer;
        this.addValidator((Validator)new EmailValidator(this.sourceAddr, ApiMessageKey.email_server_invalid_from, this.getFullPath(EmailServerSettingsPaths.getSourceAddr())));
    }

    private String getFullPath(String path) {
        return StringUtils.isBlank((String)this.pathPrefix) ? path : this.pathPrefix + path;
    }

    @Override
    public boolean validate() {
        EncryptedFieldValidator encryptedPasswordValidator;
        super.validate();
        if (!this.skipValidateEmailServer && StringUtils.isBlank((String)this.sourceAddr)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_missing_from, this.getFullPath(EmailServerSettingsPaths.getSourceAddr())));
        }
        if (!this.skipValidateEmailServer && StringUtils.isBlank((String)this.emailServer)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_server_required, this.getFullPath(EmailServerSettingsPaths.getEmailServer())));
        }
        if (StringUtils.isBlank((String)this.port)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_port_required, this.getFullPath(EmailServerSettingsPaths.getPort())));
        } else if (!ValidationUtil.isValidPort((String)this.port, (boolean)false)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_smtp_port_invalid, this.getFullPath(EmailServerSettingsPaths.getPort())));
        }
        if (StringUtils.isNotBlank((String)this.timeout) && (!ValidationUtil.isValidNonZeroPosInt((String)this.timeout) || Integer.parseInt(this.timeout) > 3600)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_invalid_timeout, this.getFullPath(EmailServerSettingsPaths.getTimeout())));
        }
        if (StringUtils.isNotBlank((String)this.retryAttempts) && (!ValidationUtil.isValidNonNegInt((String)this.retryAttempts) || Integer.parseInt(this.retryAttempts) > 5)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_retry_attempt_invalid, this.getFullPath(EmailServerSettingsPaths.getRetryAttempts()), new Object[]{5}));
        }
        if (StringUtils.isNotBlank((String)this.retryDelay) && (!ValidationUtil.isValidNonNegInt((String)this.retryDelay) || Integer.parseInt(this.retryDelay) > 10)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_retry_delay_invalid, this.getFullPath(EmailServerSettingsPaths.getRetryDelay()), new Object[]{10}));
        }
        if (this.useSSL) {
            if (StringUtils.isEmpty((String)this.sslPort)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_ssl_smtp_port_required, this.getFullPath(EmailServerSettingsPaths.getSslPort())));
            } else if (!ValidationUtil.isValidPort((String)this.sslPort, (boolean)false)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_ssl_smtp_port_invalid, this.getFullPath(EmailServerSettingsPaths.getSslPort())));
            }
        }
        if (!(encryptedPasswordValidator = new EncryptedFieldValidator(this.password, this.encryptedPassword, ApiMessageKey.email_server_encrypted_password_invalid, this.getFullPath(EmailServerSettingsPaths.getEncryptedPassword()), new Object[0])).validate()) {
            this.appendErrors(encryptedPasswordValidator.getErrors());
        } else {
            this.password = encryptedPasswordValidator.getPlaintext();
        }
        if (!StringUtils.isBlank((String)this.username) && StringUtils.isBlank((String)this.password)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_password_required, this.getFullPath(EmailServerSettingsPaths.getPassword())));
        }
        if (StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.email_server_username_required, this.getFullPath(EmailServerSettingsPaths.getUsername())));
        }
        return !this.hasErrors();
    }

    public static class Builder {
        String sourceAddr;
        String emailServer;
        String port;
        String sslPort;
        String timeout;
        String username;
        String password;
        String encryptedPassword;
        boolean useSSL;
        String pathPrefix;
        String retryAttempts;
        String retryDelay;
        boolean skipValidateEmailServer = true;

        public Builder withEmailSettings(EmailServerSettings settings) {
            this.sourceAddr = settings.getSourceAddr();
            this.emailServer = settings.getEmailServer();
            this.port = String.valueOf(settings.getPort());
            this.sslPort = String.valueOf(settings.getSslPort());
            this.timeout = String.valueOf(settings.getTimeout());
            this.retryAttempts = String.valueOf(settings.getRetryAttempts());
            this.username = settings.getUsername();
            this.password = settings.getPassword();
            this.encryptedPassword = settings.getEncryptedPassword();
            this.useSSL = settings.isUseSSL();
            this.retryAttempts = String.valueOf(settings.getRetryAttempts());
            this.retryDelay = String.valueOf(settings.getRetryDelay());
            return this;
        }

        public Builder setSourceAddr(String sourceAddr) {
            this.sourceAddr = sourceAddr;
            return this;
        }

        public Builder setEmailServer(String emailServer) {
            this.emailServer = emailServer;
            return this;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public Builder setSslPort(String sslPort) {
            this.sslPort = sslPort;
            return this;
        }

        public Builder setTimeout(String timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public Builder setEncryptedPassword(String encrypted) {
            this.encryptedPassword = encrypted;
            return this;
        }

        public String getRetryAttempts() {
            return this.retryAttempts;
        }

        public Builder setRetryAttempts(String retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public Builder setRetryDelay(String retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder setSkipValidateEmailServer(boolean skipValidateEmailServer) {
            this.skipValidateEmailServer = skipValidateEmailServer;
            return this;
        }

        public EmailServerSettingsValidator build() {
            return new EmailServerSettingsValidator(this);
        }
    }
}

