/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;
import org.sourceid.saml20.metadata.Role;

public class EnabledProfilesValidator
extends AbstractValidator {
    private final boolean idpInitSsoEnabled;
    private final boolean spInitSsoEnabled;
    private final Role role;
    private IdpConnection idpConnection;

    public EnabledProfilesValidator(IdpConnection conn) {
        this(conn.getIdpBrowserSso().getEnabledProfiles(), conn.getType().getRole());
        this.idpConnection = conn;
    }

    public EnabledProfilesValidator(SpConnection conn) {
        this(conn.getSpBrowserSso().getEnabledProfiles(), conn.getType().getRole());
    }

    private EnabledProfilesValidator(Set<Profile> enabledProfiles, Role role) {
        if (enabledProfiles == null) {
            this.idpInitSsoEnabled = false;
            this.spInitSsoEnabled = false;
        } else {
            this.idpInitSsoEnabled = enabledProfiles.contains((Object)Profile.IDP_INITIATED_SSO);
            this.spInitSsoEnabled = enabledProfiles.contains((Object)Profile.SP_INITIATED_SSO);
        }
        this.role = role;
    }

    public EnabledProfilesValidator(boolean idpInitSsoEnabled, boolean spInitSsoEnabled, Role role) {
        this.idpInitSsoEnabled = idpInitSsoEnabled;
        this.spInitSsoEnabled = spInitSsoEnabled;
        this.role = role;
    }

    public boolean validate() {
        int initNumErrors = this.getErrors().size();
        if (this.idpConnection != null && Protocol.isSaml1x(this.idpConnection.getBrowserSso().getProtocol())) {
            Set<Profile> enabledProfiles = this.idpConnection.getBrowserSso().getEnabledProfiles();
            if (!(enabledProfiles == null || enabledProfiles.isEmpty() || enabledProfiles.size() <= 1 && enabledProfiles.contains((Object)Profile.SP_INITIATED_SSO))) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.enabled_profiles_sp_sso_only_required, ConnectionPaths.getEnabledProfilesPropertyPath(this.role), new Object[]{ConnectionPaths.getEnabledProfilesPropertyPath(this.role)}));
            }
        } else if (!this.idpInitSsoEnabled && !this.spInitSsoEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.enabled_profiles_sso_required, ConnectionPaths.getEnabledProfilesPropertyPath(this.role)));
        }
        return initNumErrors == this.getErrors().size();
    }
}

